<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for set-checkpoint-response StructType
 * Meta informations extracted from the WSDL
 * - documentation: The checkpoint ID to be saved by the Web Service Connector
 * @subpackage Structs
 */
class Set_checkpoint_response extends AbstractStructBase
{
    /**
     * The checkpoint_id
     * Meta informations extracted from the WSDL
     * - documentation: The ID associated with the checkpoint data. If populated, this ID will be used in subsequent set checkpoint requests from this interview session. This is useful information for the WSC to keep only one copy of a single interview
     * session's data.
     * - use: optional
     * @var string
     */
    public $checkpoint_id;
    /**
     * Constructor method for set-checkpoint-response
     * @uses Set_checkpoint_response::setCheckpoint_id()
     * @param string $checkpoint_id
     */
    public function __construct($checkpoint_id = null)
    {
        $this
            ->setCheckpoint_id($checkpoint_id);
    }
    /**
     * Get checkpoint_id value
     * @return string|null
     */
    public function getCheckpoint_id()
    {
        return $this->{'checkpoint-id'};
    }
    /**
     * Set checkpoint_id value
     * @param string $checkpoint_id
     * @return \StructType\Set_checkpoint_response
     */
    public function setCheckpoint_id($checkpoint_id = null)
    {
        // validation for constraint: string
        if (!is_null($checkpoint_id) && !is_string($checkpoint_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkpoint_id)), __LINE__);
        }
        $this->checkpoint_id = $this->{'checkpoint-id'} = $checkpoint_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Set_checkpoint_response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
