<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for save-request StructType
 * @subpackage Structs
 */
class Save_request extends AbstractStructBase
{
    /**
     * The tables
     * Meta informations extracted from the WSDL
     * - documentation: An element containing a list of Tables for the request.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SubmitData
     */
    public $tables;
    /**
     * The root
     * Meta informations extracted from the WSDL
     * - documentation: The name of the table which was mapped to Global output.
     * - use: required
     * @var string
     */
    public $root;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - documentation: The deployment's region code. The connector may need to utilize this information if it is responsible for formatting currency, dates or other values to a field designated as a STRING field. Values passed as DECIMAL, DATE, DATETIME or
     * TIMEOFDAY will be formatted in the interview according to the settings of the policy model. (see Localization - Region)
     * - use: required
     * @var string
     */
    public $region;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - documentation: The deployment's language code. Useful if the connector is responsible for returning data in different languages, i.e. string values for fields which were described by the metadata as STRING data types.
     * - use: required
     * @var string
     */
    public $language;
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - documentation: The timezone attribute is the Timezone as specified in the deployment. This affects all "Date and Time" Policy Modeling attributes as the value mapped out will carry this Timezone value. Any Date and Time values in the response must
     * already be converted to the project's Timezone.
     * - use: required
     * @var string
     */
    public $timezone;
    /**
     * The request_context
     * Meta informations extracted from the WSDL
     * - documentation: This element contains additional parameters specified on the start session url. See Persist data using WSC.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestContext
     */
    public $request_context;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: An element containing a list of Attachments.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttachmentList
     */
    public $attachments;
    /**
     * The audit_reports
     * Meta informations extracted from the WSDL
     * - documentation: An element containing a list of AuditAttributeNodes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuditReportList
     */
    public $audit_reports;
    /**
     * Constructor method for save-request
     * @uses Save_request::setTables()
     * @uses Save_request::setRoot()
     * @uses Save_request::setRegion()
     * @uses Save_request::setLanguage()
     * @uses Save_request::setTimezone()
     * @uses Save_request::setRequest_context()
     * @uses Save_request::setAttachments()
     * @uses Save_request::setAudit_reports()
     * @param \StructType\SubmitData $tables
     * @param string $root
     * @param string $region
     * @param string $language
     * @param string $timezone
     * @param \StructType\RequestContext $request_context
     * @param \StructType\AttachmentList $attachments
     * @param \StructType\AuditReportList $audit_reports
     */
    public function __construct(\StructType\SubmitData $tables = null, $root = null, $region = null, $language = null, $timezone = null, \StructType\RequestContext $request_context = null, \StructType\AttachmentList $attachments = null, \StructType\AuditReportList $audit_reports = null)
    {
        $this
            ->setTables($tables)
            ->setRoot($root)
            ->setRegion($region)
            ->setLanguage($language)
            ->setTimezone($timezone)
            ->setRequest_context($request_context)
            ->setAttachments($attachments)
            ->setAudit_reports($audit_reports);
    }
    /**
     * Get tables value
     * @return \StructType\SubmitData
     */
    public function getTables()
    {
        return $this->tables;
    }
    /**
     * Set tables value
     * @param \StructType\SubmitData $tables
     * @return \StructType\Save_request
     */
    public function setTables(\StructType\SubmitData $tables = null)
    {
        $this->tables = $tables;
        return $this;
    }
    /**
     * Get root value
     * @return string
     */
    public function getRoot()
    {
        return $this->root;
    }
    /**
     * Set root value
     * @param string $root
     * @return \StructType\Save_request
     */
    public function setRoot($root = null)
    {
        // validation for constraint: string
        if (!is_null($root) && !is_string($root)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($root)), __LINE__);
        }
        $this->root = $root;
        return $this;
    }
    /**
     * Get region value
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\Save_request
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Save_request
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get timezone value
     * @return string
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param string $timezone
     * @return \StructType\Save_request
     */
    public function setTimezone($timezone = null)
    {
        // validation for constraint: string
        if (!is_null($timezone) && !is_string($timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timezone)), __LINE__);
        }
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Get request_context value
     * @return \StructType\RequestContext|null
     */
    public function getRequest_context()
    {
        return $this->{'request-context'};
    }
    /**
     * Set request_context value
     * @param \StructType\RequestContext $request_context
     * @return \StructType\Save_request
     */
    public function setRequest_context(\StructType\RequestContext $request_context = null)
    {
        $this->request_context = $this->{'request-context'} = $request_context;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentList|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\AttachmentList $attachments
     * @return \StructType\Save_request
     */
    public function setAttachments(\StructType\AttachmentList $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Get audit_reports value
     * @return \StructType\AuditReportList|null
     */
    public function getAudit_reports()
    {
        return $this->{'audit-reports'};
    }
    /**
     * Set audit_reports value
     * @param \StructType\AuditReportList $audit_reports
     * @return \StructType\Save_request
     */
    public function setAudit_reports(\StructType\AuditReportList $audit_reports = null)
    {
        $this->audit_reports = $this->{'audit-reports'} = $audit_reports;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Save_request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
