<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipAuditNode StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the relationship-node attribute of AuditReportList and of RelationshipAuditNode in the request of a Save data action.
 * @subpackage Structs
 */
class RelationshipAuditNode extends AbstractStructBase
{
    /**
     * The node_id
     * Meta informations extracted from the WSDL
     * - documentation: An identifier for the decision report node. When a relationship occurs more than once in a decision report, a reference is made to the first appearance by using this identifier.
     * - use: required
     * @var string
     */
    public $node_id;
    /**
     * The relationship_id
     * Meta informations extracted from the WSDL
     * - documentation: The name of the relationship for this decision report node
     * - use: required
     * @var string
     */
    public $relationship_id;
    /**
     * The relationship_type
     * Meta informations extracted from the WSDL
     * - documentation: The cardinality of the relationship, as specified by the enumeration
     * - use: required
     * @var string
     */
    public $relationship_type;
    /**
     * The source_entity_id
     * Meta informations extracted from the WSDL
     * - documentation: The name of the type of source entity to which this relationship refers
     * - use: required
     * @var string
     */
    public $source_entity_id;
    /**
     * The source_instance_id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier of the source entity instance for this relationship
     * - use: required
     * @var string
     */
    public $source_instance_id;
    /**
     * The target_entity_id
     * Meta informations extracted from the WSDL
     * - documentation: The name of the type of target entity to which this relationship refers
     * - use: required
     * @var string
     */
    public $target_entity_id;
    /**
     * The relationship_state
     * Meta informations extracted from the WSDL
     * - documentation: The relationship state, as specified by the enumeration
     * - use: required
     * @var string
     */
    public $relationship_state;
    /**
     * The is_user_set
     * Meta informations extracted from the WSDL
     * - documentation: Whether the relationship is user-set, or inferred
     * - use: required
     * @var bool
     */
    public $is_user_set;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: The text of the decision report for this node
     * - use: required
     * @var string
     */
    public $text;
    /**
     * The reference_tags
     * Meta informations extracted from the WSDL
     * - documentation: Contains the reference tags for this audit report node.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReferenceTagList
     */
    public $reference_tags;
    /**
     * The entity_node
     * Meta informations extracted from the WSDL
     * - documentation: entity-node
     * @var \StructType\EntityAuditNode
     */
    public $entity_node;
    /**
     * The attribute_node
     * Meta informations extracted from the WSDL
     * - documentation: Decision report for another attribute that is relevant to the decision report for this relationship
     * @var \StructType\AttributeAuditNode
     */
    public $attribute_node;
    /**
     * The relationship_node
     * Meta informations extracted from the WSDL
     * - documentation: Decision report for a relationship that is relevant to the decision report for this relationship
     * @var \StructType\RelationshipAuditNode
     */
    public $relationship_node;
    /**
     * The already_proven_node
     * Meta informations extracted from the WSDL
     * - documentation: A cross-reference to another decision report node that is relevant to the decision report for this relationship
     * @var \StructType\ReferenceAuditNode
     */
    public $already_proven_node;
    /**
     * The start_relevance
     * Meta informations extracted from the WSDL
     * - documentation: If the relevance does not start at the beginning of time, the first date on which the relationship became relevant to the decision report. Can only be set if temporal rules or values are in use.
     * - use: optional
     * @var string
     */
    public $start_relevance;
    /**
     * The end_relevance
     * Meta informations extracted from the WSDL
     * - documentation: If the relevance does not continue to the end of time, the date on and after which the relationship was no longer relevant to the decision report. Can only be set if temporal rules or values are in use.
     * - use: optional
     * @var string
     */
    public $end_relevance;
    /**
     * Constructor method for RelationshipAuditNode
     * @uses RelationshipAuditNode::setNode_id()
     * @uses RelationshipAuditNode::setRelationship_id()
     * @uses RelationshipAuditNode::setRelationship_type()
     * @uses RelationshipAuditNode::setSource_entity_id()
     * @uses RelationshipAuditNode::setSource_instance_id()
     * @uses RelationshipAuditNode::setTarget_entity_id()
     * @uses RelationshipAuditNode::setRelationship_state()
     * @uses RelationshipAuditNode::setIs_user_set()
     * @uses RelationshipAuditNode::setText()
     * @uses RelationshipAuditNode::setReference_tags()
     * @uses RelationshipAuditNode::setEntity_node()
     * @uses RelationshipAuditNode::setAttribute_node()
     * @uses RelationshipAuditNode::setRelationship_node()
     * @uses RelationshipAuditNode::setAlready_proven_node()
     * @uses RelationshipAuditNode::setStart_relevance()
     * @uses RelationshipAuditNode::setEnd_relevance()
     * @param string $node_id
     * @param string $relationship_id
     * @param string $relationship_type
     * @param string $source_entity_id
     * @param string $source_instance_id
     * @param string $target_entity_id
     * @param string $relationship_state
     * @param bool $is_user_set
     * @param string $text
     * @param \StructType\ReferenceTagList $reference_tags
     * @param \StructType\EntityAuditNode $entity_node
     * @param \StructType\AttributeAuditNode $attribute_node
     * @param \StructType\RelationshipAuditNode $relationship_node
     * @param \StructType\ReferenceAuditNode $already_proven_node
     * @param string $start_relevance
     * @param string $end_relevance
     */
    public function __construct($node_id = null, $relationship_id = null, $relationship_type = null, $source_entity_id = null, $source_instance_id = null, $target_entity_id = null, $relationship_state = null, $is_user_set = null, $text = null, \StructType\ReferenceTagList $reference_tags = null, \StructType\EntityAuditNode $entity_node = null, \StructType\AttributeAuditNode $attribute_node = null, \StructType\RelationshipAuditNode $relationship_node = null, \StructType\ReferenceAuditNode $already_proven_node = null, $start_relevance = null, $end_relevance = null)
    {
        $this
            ->setNode_id($node_id)
            ->setRelationship_id($relationship_id)
            ->setRelationship_type($relationship_type)
            ->setSource_entity_id($source_entity_id)
            ->setSource_instance_id($source_instance_id)
            ->setTarget_entity_id($target_entity_id)
            ->setRelationship_state($relationship_state)
            ->setIs_user_set($is_user_set)
            ->setText($text)
            ->setReference_tags($reference_tags)
            ->setEntity_node($entity_node)
            ->setAttribute_node($attribute_node)
            ->setRelationship_node($relationship_node)
            ->setAlready_proven_node($already_proven_node)
            ->setStart_relevance($start_relevance)
            ->setEnd_relevance($end_relevance);
    }
    /**
     * Get node_id value
     * @return string
     */
    public function getNode_id()
    {
        return $this->{'node-id'};
    }
    /**
     * Set node_id value
     * @param string $node_id
     * @return \StructType\RelationshipAuditNode
     */
    public function setNode_id($node_id = null)
    {
        // validation for constraint: string
        if (!is_null($node_id) && !is_string($node_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($node_id)), __LINE__);
        }
        $this->node_id = $this->{'node-id'} = $node_id;
        return $this;
    }
    /**
     * Get relationship_id value
     * @return string
     */
    public function getRelationship_id()
    {
        return $this->{'relationship-id'};
    }
    /**
     * Set relationship_id value
     * @param string $relationship_id
     * @return \StructType\RelationshipAuditNode
     */
    public function setRelationship_id($relationship_id = null)
    {
        // validation for constraint: string
        if (!is_null($relationship_id) && !is_string($relationship_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationship_id)), __LINE__);
        }
        $this->relationship_id = $this->{'relationship-id'} = $relationship_id;
        return $this;
    }
    /**
     * Get relationship_type value
     * @return string
     */
    public function getRelationship_type()
    {
        return $this->{'relationship-type'};
    }
    /**
     * Set relationship_type value
     * @uses \EnumType\RelationshipCardinalityEnum::valueIsValid()
     * @uses \EnumType\RelationshipCardinalityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationship_type
     * @return \StructType\RelationshipAuditNode
     */
    public function setRelationship_type($relationship_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RelationshipCardinalityEnum::valueIsValid($relationship_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $relationship_type, implode(', ', \EnumType\RelationshipCardinalityEnum::getValidValues())), __LINE__);
        }
        $this->relationship_type = $this->{'relationship-type'} = $relationship_type;
        return $this;
    }
    /**
     * Get source_entity_id value
     * @return string
     */
    public function getSource_entity_id()
    {
        return $this->{'source-entity-id'};
    }
    /**
     * Set source_entity_id value
     * @param string $source_entity_id
     * @return \StructType\RelationshipAuditNode
     */
    public function setSource_entity_id($source_entity_id = null)
    {
        // validation for constraint: string
        if (!is_null($source_entity_id) && !is_string($source_entity_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source_entity_id)), __LINE__);
        }
        $this->source_entity_id = $this->{'source-entity-id'} = $source_entity_id;
        return $this;
    }
    /**
     * Get source_instance_id value
     * @return string
     */
    public function getSource_instance_id()
    {
        return $this->{'source-instance-id'};
    }
    /**
     * Set source_instance_id value
     * @param string $source_instance_id
     * @return \StructType\RelationshipAuditNode
     */
    public function setSource_instance_id($source_instance_id = null)
    {
        // validation for constraint: string
        if (!is_null($source_instance_id) && !is_string($source_instance_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source_instance_id)), __LINE__);
        }
        $this->source_instance_id = $this->{'source-instance-id'} = $source_instance_id;
        return $this;
    }
    /**
     * Get target_entity_id value
     * @return string
     */
    public function getTarget_entity_id()
    {
        return $this->{'target-entity-id'};
    }
    /**
     * Set target_entity_id value
     * @param string $target_entity_id
     * @return \StructType\RelationshipAuditNode
     */
    public function setTarget_entity_id($target_entity_id = null)
    {
        // validation for constraint: string
        if (!is_null($target_entity_id) && !is_string($target_entity_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target_entity_id)), __LINE__);
        }
        $this->target_entity_id = $this->{'target-entity-id'} = $target_entity_id;
        return $this;
    }
    /**
     * Get relationship_state value
     * @return string
     */
    public function getRelationship_state()
    {
        return $this->{'relationship-state'};
    }
    /**
     * Set relationship_state value
     * @uses \EnumType\StateEnum::valueIsValid()
     * @uses \EnumType\StateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationship_state
     * @return \StructType\RelationshipAuditNode
     */
    public function setRelationship_state($relationship_state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateEnum::valueIsValid($relationship_state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $relationship_state, implode(', ', \EnumType\StateEnum::getValidValues())), __LINE__);
        }
        $this->relationship_state = $this->{'relationship-state'} = $relationship_state;
        return $this;
    }
    /**
     * Get is_user_set value
     * @return bool
     */
    public function getIs_user_set()
    {
        return $this->{'is-user-set'};
    }
    /**
     * Set is_user_set value
     * @param bool $is_user_set
     * @return \StructType\RelationshipAuditNode
     */
    public function setIs_user_set($is_user_set = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_user_set) && !is_bool($is_user_set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_user_set)), __LINE__);
        }
        $this->is_user_set = $this->{'is-user-set'} = $is_user_set;
        return $this;
    }
    /**
     * Get text value
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\RelationshipAuditNode
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get reference_tags value
     * @return \StructType\ReferenceTagList|null
     */
    public function getReference_tags()
    {
        return $this->{'reference-tags'};
    }
    /**
     * Set reference_tags value
     * @param \StructType\ReferenceTagList $reference_tags
     * @return \StructType\RelationshipAuditNode
     */
    public function setReference_tags(\StructType\ReferenceTagList $reference_tags = null)
    {
        $this->reference_tags = $this->{'reference-tags'} = $reference_tags;
        return $this;
    }
    /**
     * Get entity_node value
     * @return \StructType\EntityAuditNode|null
     */
    public function getEntity_node()
    {
        return $this->{'entity-node'};
    }
    /**
     * Set entity_node value
     * @param \StructType\EntityAuditNode $entity_node
     * @return \StructType\RelationshipAuditNode
     */
    public function setEntity_node(\StructType\EntityAuditNode $entity_node = null)
    {
        $this->entity_node = $this->{'entity-node'} = $entity_node;
        return $this;
    }
    /**
     * Get attribute_node value
     * @return \StructType\AttributeAuditNode|null
     */
    public function getAttribute_node()
    {
        return $this->{'attribute-node'};
    }
    /**
     * Set attribute_node value
     * @param \StructType\AttributeAuditNode $attribute_node
     * @return \StructType\RelationshipAuditNode
     */
    public function setAttribute_node(\StructType\AttributeAuditNode $attribute_node = null)
    {
        $this->attribute_node = $this->{'attribute-node'} = $attribute_node;
        return $this;
    }
    /**
     * Get relationship_node value
     * @return \StructType\RelationshipAuditNode|null
     */
    public function getRelationship_node()
    {
        return $this->{'relationship-node'};
    }
    /**
     * Set relationship_node value
     * @param \StructType\RelationshipAuditNode $relationship_node
     * @return \StructType\RelationshipAuditNode
     */
    public function setRelationship_node(\StructType\RelationshipAuditNode $relationship_node = null)
    {
        $this->relationship_node = $this->{'relationship-node'} = $relationship_node;
        return $this;
    }
    /**
     * Get already_proven_node value
     * @return \StructType\ReferenceAuditNode|null
     */
    public function getAlready_proven_node()
    {
        return $this->{'already-proven-node'};
    }
    /**
     * Set already_proven_node value
     * @param \StructType\ReferenceAuditNode $already_proven_node
     * @return \StructType\RelationshipAuditNode
     */
    public function setAlready_proven_node(\StructType\ReferenceAuditNode $already_proven_node = null)
    {
        $this->already_proven_node = $this->{'already-proven-node'} = $already_proven_node;
        return $this;
    }
    /**
     * Get start_relevance value
     * @return string|null
     */
    public function getStart_relevance()
    {
        return $this->{'start-relevance'};
    }
    /**
     * Set start_relevance value
     * @param string $start_relevance
     * @return \StructType\RelationshipAuditNode
     */
    public function setStart_relevance($start_relevance = null)
    {
        // validation for constraint: string
        if (!is_null($start_relevance) && !is_string($start_relevance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_relevance)), __LINE__);
        }
        $this->start_relevance = $this->{'start-relevance'} = $start_relevance;
        return $this;
    }
    /**
     * Get end_relevance value
     * @return string|null
     */
    public function getEnd_relevance()
    {
        return $this->{'end-relevance'};
    }
    /**
     * Set end_relevance value
     * @param string $end_relevance
     * @return \StructType\RelationshipAuditNode
     */
    public function setEnd_relevance($end_relevance = null)
    {
        // validation for constraint: string
        if (!is_null($end_relevance) && !is_string($end_relevance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end_relevance)), __LINE__);
        }
        $this->end_relevance = $this->{'end-relevance'} = $end_relevance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelationshipAuditNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
