<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceTagList StructType
 * Meta informations extracted from the WSDL
 * - documentation: A container for reference tags
 * @subpackage Structs
 */
class ReferenceTagList extends AbstractStructBase
{
    /**
     * The reference_tag
     * Meta informations extracted from the WSDL
     * - documentation: The reference tag definition
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ReferenceTag[]
     */
    public $reference_tag;
    /**
     * Constructor method for ReferenceTagList
     * @uses ReferenceTagList::setReference_tag()
     * @param \StructType\ReferenceTag[] $reference_tag
     */
    public function __construct(array $reference_tag = array())
    {
        $this
            ->setReference_tag($reference_tag);
    }
    /**
     * Get reference_tag value
     * @return \StructType\ReferenceTag[]
     */
    public function getReference_tag()
    {
        return $this->{'reference-tag'};
    }
    /**
     * Set reference_tag value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceTag[] $reference_tag
     * @return \StructType\ReferenceTagList
     */
    public function setReference_tag(array $reference_tag = array())
    {
        foreach ($reference_tag as $referenceTagListReference_tagItem) {
            // validation for constraint: itemType
            if (!$referenceTagListReference_tagItem instanceof \StructType\ReferenceTag) {
                throw new \InvalidArgumentException(sprintf('The reference_tag property can only contain items of \StructType\ReferenceTag, "%s" given', is_object($referenceTagListReference_tagItem) ? get_class($referenceTagListReference_tagItem) : gettype($referenceTagListReference_tagItem)), __LINE__);
            }
        }
        $this->reference_tag = $this->{'reference-tag'} = $reference_tag;
        return $this;
    }
    /**
     */
    public function addToReference_tag(\StructType\ReferenceTag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceTag) {
            throw new \InvalidArgumentException(sprintf('The reference_tag property can only contain items of \StructType\ReferenceTag, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->reference_tag[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceTagList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
