<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumberEnumVal StructType
 * @subpackage Structs
 */
class NumberEnumVal extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * The ChildValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChildEnumValues
     */
    public $ChildValues;
    /**
     * The UncheckedImageUrl
     * @var string
     */
    public $UncheckedImageUrl;
    /**
     * The UncheckedImageData
     * @var \StructType\BinaryImage
     */
    public $UncheckedImageData;
    /**
     * The CheckedImageUrl
     * @var string
     */
    public $CheckedImageUrl;
    /**
     * The CheckedImageData
     * @var \StructType\BinaryImage
     */
    public $CheckedImageData;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $description;
    /**
     * Constructor method for NumberEnumVal
     * @uses NumberEnumVal::setValue()
     * @uses NumberEnumVal::setChildValues()
     * @uses NumberEnumVal::setUncheckedImageUrl()
     * @uses NumberEnumVal::setUncheckedImageData()
     * @uses NumberEnumVal::setCheckedImageUrl()
     * @uses NumberEnumVal::setCheckedImageData()
     * @uses NumberEnumVal::setDescription()
     * @param float $value
     * @param \StructType\ChildEnumValues $childValues
     * @param string $uncheckedImageUrl
     * @param \StructType\BinaryImage $uncheckedImageData
     * @param string $checkedImageUrl
     * @param \StructType\BinaryImage $checkedImageData
     * @param string $description
     */
    public function __construct($value = null, \StructType\ChildEnumValues $childValues = null, $uncheckedImageUrl = null, \StructType\BinaryImage $uncheckedImageData = null, $checkedImageUrl = null, \StructType\BinaryImage $checkedImageData = null, $description = null)
    {
        $this
            ->setValue($value)
            ->setChildValues($childValues)
            ->setUncheckedImageUrl($uncheckedImageUrl)
            ->setUncheckedImageData($uncheckedImageData)
            ->setCheckedImageUrl($checkedImageUrl)
            ->setCheckedImageData($checkedImageData)
            ->setDescription($description);
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\NumberEnumVal
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ChildValues value
     * @return \StructType\ChildEnumValues|null
     */
    public function getChildValues()
    {
        return $this->ChildValues;
    }
    /**
     * Set ChildValues value
     * @param \StructType\ChildEnumValues $childValues
     * @return \StructType\NumberEnumVal
     */
    public function setChildValues(\StructType\ChildEnumValues $childValues = null)
    {
        $this->ChildValues = $childValues;
        return $this;
    }
    /**
     * Get UncheckedImageUrl value
     * @return string|null
     */
    public function getUncheckedImageUrl()
    {
        return $this->UncheckedImageUrl;
    }
    /**
     * Set UncheckedImageUrl value
     * @param string $uncheckedImageUrl
     * @return \StructType\NumberEnumVal
     */
    public function setUncheckedImageUrl($uncheckedImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($uncheckedImageUrl) && !is_string($uncheckedImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uncheckedImageUrl)), __LINE__);
        }
        $this->UncheckedImageUrl = $uncheckedImageUrl;
        return $this;
    }
    /**
     * Get UncheckedImageData value
     * @return \StructType\BinaryImage|null
     */
    public function getUncheckedImageData()
    {
        return $this->UncheckedImageData;
    }
    /**
     * Set UncheckedImageData value
     * @param \StructType\BinaryImage $uncheckedImageData
     * @return \StructType\NumberEnumVal
     */
    public function setUncheckedImageData(\StructType\BinaryImage $uncheckedImageData = null)
    {
        $this->UncheckedImageData = $uncheckedImageData;
        return $this;
    }
    /**
     * Get CheckedImageUrl value
     * @return string|null
     */
    public function getCheckedImageUrl()
    {
        return $this->CheckedImageUrl;
    }
    /**
     * Set CheckedImageUrl value
     * @param string $checkedImageUrl
     * @return \StructType\NumberEnumVal
     */
    public function setCheckedImageUrl($checkedImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($checkedImageUrl) && !is_string($checkedImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkedImageUrl)), __LINE__);
        }
        $this->CheckedImageUrl = $checkedImageUrl;
        return $this;
    }
    /**
     * Get CheckedImageData value
     * @return \StructType\BinaryImage|null
     */
    public function getCheckedImageData()
    {
        return $this->CheckedImageData;
    }
    /**
     * Set CheckedImageData value
     * @param \StructType\BinaryImage $checkedImageData
     * @return \StructType\NumberEnumVal
     */
    public function setCheckedImageData(\StructType\BinaryImage $checkedImageData = null)
    {
        $this->CheckedImageData = $checkedImageData;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\NumberEnumVal
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NumberEnumVal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
