<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaTable StructType
 * @subpackage Structs
 */
class MetaTable extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the table. This will appear to policy model authors if a description is not provided.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The can_be_input
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the table can be selected as a Global input or not.
     * - use: required
     * @var bool
     */
    public $can_be_input;
    /**
     * The can_be_output
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the table can be selected as a Global output or not.
     * - use: required
     * @var bool
     */
    public $can_be_output;
    /**
     * The accepts_attachments
     * Meta informations extracted from the WSDL
     * - documentation: Defines if attachments can be collected for rows of this table.
     * - use: required
     * @var bool
     */
    public $accepts_attachments;
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - documentation: The fields of the table.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MetaField[]
     */
    public $Field;
    /**
     * The Link
     * Meta informations extracted from the WSDL
     * - documentation: Links from this table to other tables.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MetaLink[]
     */
    public $Link;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: If provided, will be displayed as the table's name in OPM, but SOAP requests and responses will continue to use the name attribute's value as the table's identifier. This attribute is intended for providing localized metadata
     * descriptions.
     * - use: optional
     * @var string
     */
    public $description;
    /**
     * Constructor method for MetaTable
     * @uses MetaTable::setName()
     * @uses MetaTable::setCan_be_input()
     * @uses MetaTable::setCan_be_output()
     * @uses MetaTable::setAccepts_attachments()
     * @uses MetaTable::setField()
     * @uses MetaTable::setLink()
     * @uses MetaTable::setDescription()
     * @param string $name
     * @param bool $can_be_input
     * @param bool $can_be_output
     * @param bool $accepts_attachments
     * @param \StructType\MetaField[] $field
     * @param \StructType\MetaLink[] $link
     * @param string $description
     */
    public function __construct($name = null, $can_be_input = null, $can_be_output = null, $accepts_attachments = null, array $field = array(), array $link = array(), $description = null)
    {
        $this
            ->setName($name)
            ->setCan_be_input($can_be_input)
            ->setCan_be_output($can_be_output)
            ->setAccepts_attachments($accepts_attachments)
            ->setField($field)
            ->setLink($link)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MetaTable
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get can_be_input value
     * @return bool
     */
    public function getCan_be_input()
    {
        return $this->{'can-be-input'};
    }
    /**
     * Set can_be_input value
     * @param bool $can_be_input
     * @return \StructType\MetaTable
     */
    public function setCan_be_input($can_be_input = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_be_input) && !is_bool($can_be_input)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_be_input)), __LINE__);
        }
        $this->can_be_input = $this->{'can-be-input'} = $can_be_input;
        return $this;
    }
    /**
     * Get can_be_output value
     * @return bool
     */
    public function getCan_be_output()
    {
        return $this->{'can-be-output'};
    }
    /**
     * Set can_be_output value
     * @param bool $can_be_output
     * @return \StructType\MetaTable
     */
    public function setCan_be_output($can_be_output = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_be_output) && !is_bool($can_be_output)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_be_output)), __LINE__);
        }
        $this->can_be_output = $this->{'can-be-output'} = $can_be_output;
        return $this;
    }
    /**
     * Get accepts_attachments value
     * @return bool
     */
    public function getAccepts_attachments()
    {
        return $this->{'accepts-attachments'};
    }
    /**
     * Set accepts_attachments value
     * @param bool $accepts_attachments
     * @return \StructType\MetaTable
     */
    public function setAccepts_attachments($accepts_attachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($accepts_attachments) && !is_bool($accepts_attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accepts_attachments)), __LINE__);
        }
        $this->accepts_attachments = $this->{'accepts-attachments'} = $accepts_attachments;
        return $this;
    }
    /**
     * Get Field value
     * @return \StructType\MetaField[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaField[] $field
     * @return \StructType\MetaTable
     */
    public function setField(array $field = array())
    {
        foreach ($field as $metaTableFieldItem) {
            // validation for constraint: itemType
            if (!$metaTableFieldItem instanceof \StructType\MetaField) {
                throw new \InvalidArgumentException(sprintf('The Field property can only contain items of \StructType\MetaField, "%s" given', is_object($metaTableFieldItem) ? get_class($metaTableFieldItem) : gettype($metaTableFieldItem)), __LINE__);
            }
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaField $item
     * @return \StructType\MetaTable
     */
    public function addToField(\StructType\MetaField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MetaField) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of \StructType\MetaField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Get Link value
     * @return \StructType\MetaLink[]|null
     */
    public function getLink()
    {
        return $this->Link;
    }
    /**
     * Set Link value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaLink[] $link
     * @return \StructType\MetaTable
     */
    public function setLink(array $link = array())
    {
        foreach ($link as $metaTableLinkItem) {
            // validation for constraint: itemType
            if (!$metaTableLinkItem instanceof \StructType\MetaLink) {
                throw new \InvalidArgumentException(sprintf('The Link property can only contain items of \StructType\MetaLink, "%s" given', is_object($metaTableLinkItem) ? get_class($metaTableLinkItem) : gettype($metaTableLinkItem)), __LINE__);
            }
        }
        $this->Link = $link;
        return $this;
    }
    /**
     * Add item to Link value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaLink $item
     * @return \StructType\MetaTable
     */
    public function addToLink(\StructType\MetaLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MetaLink) {
            throw new \InvalidArgumentException(sprintf('The Link property can only contain items of \StructType\MetaLink, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Link[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MetaTable
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MetaTable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
