<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaLink StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for an attribute of MetaTable in the metadata response of a GetMetadata action.
 * @subpackage Structs
 */
class MetaLink extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the link. This will appear to policy model authors if a description is not provided.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - documentation: The target table's name.
     * - use: required
     * @var string
     */
    public $target;
    /**
     * The cardinality
     * Meta informations extracted from the WSDL
     * - documentation: The cardinality which the Link has to the target table.
     * - use: required
     * @var string
     */
    public $cardinality;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: If provided, will be displayed as the link's name in OPM, but SOAP requests and responses will continue to use the name attribute's value as the link's identifier. This attribute is intended for providing localized metadata
     * descriptions.
     * - use: optional
     * @var string
     */
    public $description;
    /**
     * Constructor method for MetaLink
     * @uses MetaLink::setName()
     * @uses MetaLink::setTarget()
     * @uses MetaLink::setCardinality()
     * @uses MetaLink::setDescription()
     * @param string $name
     * @param string $target
     * @param string $cardinality
     * @param string $description
     */
    public function __construct($name = null, $target = null, $cardinality = null, $description = null)
    {
        $this
            ->setName($name)
            ->setTarget($target)
            ->setCardinality($cardinality)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MetaLink
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get target value
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\MetaLink
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get cardinality value
     * @return string
     */
    public function getCardinality()
    {
        return $this->cardinality;
    }
    /**
     * Set cardinality value
     * @uses \EnumType\MetaLinkCardinality::valueIsValid()
     * @uses \EnumType\MetaLinkCardinality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardinality
     * @return \StructType\MetaLink
     */
    public function setCardinality($cardinality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MetaLinkCardinality::valueIsValid($cardinality)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cardinality, implode(', ', \EnumType\MetaLinkCardinality::getValidValues())), __LINE__);
        }
        $this->cardinality = $cardinality;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MetaLink
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MetaLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
