<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaEnumList StructType
 * @subpackage Structs
 */
class MetaEnumList extends AbstractStructBase
{
    /**
     * The NumberEnumeration
     * @var \StructType\NumberEnumeration
     */
    public $NumberEnumeration;
    /**
     * The StringEnumeration
     * @var \StructType\StringEnumeration
     */
    public $StringEnumeration;
    /**
     * The DateEnumeration
     * @var \StructType\DateEnumeration
     */
    public $DateEnumeration;
    /**
     * The DateTimeEnumeration
     * @var \StructType\DateTimeEnumeration
     */
    public $DateTimeEnumeration;
    /**
     * The TimeEnumeration
     * @var \StructType\TimeEnumeration
     */
    public $TimeEnumeration;
    /**
     * The BooleanEnumeration
     * @var \StructType\BooleanEnumeration
     */
    public $BooleanEnumeration;
    /**
     * Constructor method for MetaEnumList
     * @uses MetaEnumList::setNumberEnumeration()
     * @uses MetaEnumList::setStringEnumeration()
     * @uses MetaEnumList::setDateEnumeration()
     * @uses MetaEnumList::setDateTimeEnumeration()
     * @uses MetaEnumList::setTimeEnumeration()
     * @uses MetaEnumList::setBooleanEnumeration()
     * @param \StructType\NumberEnumeration $numberEnumeration
     * @param \StructType\StringEnumeration $stringEnumeration
     * @param \StructType\DateEnumeration $dateEnumeration
     * @param \StructType\DateTimeEnumeration $dateTimeEnumeration
     * @param \StructType\TimeEnumeration $timeEnumeration
     * @param \StructType\BooleanEnumeration $booleanEnumeration
     */
    public function __construct(\StructType\NumberEnumeration $numberEnumeration = null, \StructType\StringEnumeration $stringEnumeration = null, \StructType\DateEnumeration $dateEnumeration = null, \StructType\DateTimeEnumeration $dateTimeEnumeration = null, \StructType\TimeEnumeration $timeEnumeration = null, \StructType\BooleanEnumeration $booleanEnumeration = null)
    {
        $this
            ->setNumberEnumeration($numberEnumeration)
            ->setStringEnumeration($stringEnumeration)
            ->setDateEnumeration($dateEnumeration)
            ->setDateTimeEnumeration($dateTimeEnumeration)
            ->setTimeEnumeration($timeEnumeration)
            ->setBooleanEnumeration($booleanEnumeration);
    }
    /**
     * Get NumberEnumeration value
     * @return \StructType\NumberEnumeration|null
     */
    public function getNumberEnumeration()
    {
        return $this->NumberEnumeration;
    }
    /**
     * Set NumberEnumeration value
     * @param \StructType\NumberEnumeration $numberEnumeration
     * @return \StructType\MetaEnumList
     */
    public function setNumberEnumeration(\StructType\NumberEnumeration $numberEnumeration = null)
    {
        $this->NumberEnumeration = $numberEnumeration;
        return $this;
    }
    /**
     * Get StringEnumeration value
     * @return \StructType\StringEnumeration|null
     */
    public function getStringEnumeration()
    {
        return $this->StringEnumeration;
    }
    /**
     * Set StringEnumeration value
     * @param \StructType\StringEnumeration $stringEnumeration
     * @return \StructType\MetaEnumList
     */
    public function setStringEnumeration(\StructType\StringEnumeration $stringEnumeration = null)
    {
        $this->StringEnumeration = $stringEnumeration;
        return $this;
    }
    /**
     * Get DateEnumeration value
     * @return \StructType\DateEnumeration|null
     */
    public function getDateEnumeration()
    {
        return $this->DateEnumeration;
    }
    /**
     * Set DateEnumeration value
     * @param \StructType\DateEnumeration $dateEnumeration
     * @return \StructType\MetaEnumList
     */
    public function setDateEnumeration(\StructType\DateEnumeration $dateEnumeration = null)
    {
        $this->DateEnumeration = $dateEnumeration;
        return $this;
    }
    /**
     * Get DateTimeEnumeration value
     * @return \StructType\DateTimeEnumeration|null
     */
    public function getDateTimeEnumeration()
    {
        return $this->DateTimeEnumeration;
    }
    /**
     * Set DateTimeEnumeration value
     * @param \StructType\DateTimeEnumeration $dateTimeEnumeration
     * @return \StructType\MetaEnumList
     */
    public function setDateTimeEnumeration(\StructType\DateTimeEnumeration $dateTimeEnumeration = null)
    {
        $this->DateTimeEnumeration = $dateTimeEnumeration;
        return $this;
    }
    /**
     * Get TimeEnumeration value
     * @return \StructType\TimeEnumeration|null
     */
    public function getTimeEnumeration()
    {
        return $this->TimeEnumeration;
    }
    /**
     * Set TimeEnumeration value
     * @param \StructType\TimeEnumeration $timeEnumeration
     * @return \StructType\MetaEnumList
     */
    public function setTimeEnumeration(\StructType\TimeEnumeration $timeEnumeration = null)
    {
        $this->TimeEnumeration = $timeEnumeration;
        return $this;
    }
    /**
     * Get BooleanEnumeration value
     * @return \StructType\BooleanEnumeration|null
     */
    public function getBooleanEnumeration()
    {
        return $this->BooleanEnumeration;
    }
    /**
     * Set BooleanEnumeration value
     * @param \StructType\BooleanEnumeration $booleanEnumeration
     * @return \StructType\MetaEnumList
     */
    public function setBooleanEnumeration(\StructType\BooleanEnumeration $booleanEnumeration = null)
    {
        $this->BooleanEnumeration = $booleanEnumeration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MetaEnumList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
