<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the tables attribute in the response of a Load data action, and for the start-interview-request attribute in the request of the interview API's StartInterview action.
 * @subpackage Structs
 */
class LoadData extends AbstractStructBase
{
    /**
     * The table
     * Meta informations extracted from the WSDL
     * - documentation: A table with instances (rows) populated by a web service connector.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataTable[]
     */
    public $table;
    /**
     * Constructor method for LoadData
     * @uses LoadData::setTable()
     * @param \StructType\DataTable[] $table
     */
    public function __construct(array $table = array())
    {
        $this
            ->setTable($table);
    }
    /**
     * Get table value
     * @return \StructType\DataTable[]|null
     */
    public function getTable()
    {
        return $this->table;
    }
    /**
     * Set table value
     * @throws \InvalidArgumentException
     * @param \StructType\DataTable[] $table
     * @return \StructType\LoadData
     */
    public function setTable(array $table = array())
    {
        foreach ($table as $loadDataTableItem) {
            // validation for constraint: itemType
            if (!$loadDataTableItem instanceof \StructType\DataTable) {
                throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\DataTable, "%s" given', is_object($loadDataTableItem) ? get_class($loadDataTableItem) : gettype($loadDataTableItem)), __LINE__);
            }
        }
        $this->table = $table;
        return $this;
    }
    /**
     * Add item to table value
     * @throws \InvalidArgumentException
     * @param \StructType\DataTable $item
     * @return \StructType\LoadData
     */
    public function addToTable(\StructType\DataTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataTable) {
            throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\DataTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->table[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoadData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
