<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for get-metadata-response StructType
 * @subpackage Structs
 */
class Get_metadata_response extends AbstractStructBase
{
    /**
     * The supports_checkpoints
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $supports_checkpoints;
    /**
     * The MetadataEnumerations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetaEnumList
     */
    public $MetadataEnumerations;
    /**
     * The Table
     * Meta informations extracted from the WSDL
     * - documentation: Describes a table which can be used for mapping purposes in an OPM project.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MetaTable[]
     */
    public $Table;
    /**
     * Constructor method for get-metadata-response
     * @uses Get_metadata_response::setSupports_checkpoints()
     * @uses Get_metadata_response::setMetadataEnumerations()
     * @uses Get_metadata_response::setTable()
     * @param bool $supports_checkpoints
     * @param \StructType\MetaEnumList $metadataEnumerations
     * @param \StructType\MetaTable[] $table
     */
    public function __construct($supports_checkpoints = null, \StructType\MetaEnumList $metadataEnumerations = null, array $table = array())
    {
        $this
            ->setSupports_checkpoints($supports_checkpoints)
            ->setMetadataEnumerations($metadataEnumerations)
            ->setTable($table);
    }
    /**
     * Get supports_checkpoints value
     * @return bool
     */
    public function getSupports_checkpoints()
    {
        return $this->{'supports-checkpoints'};
    }
    /**
     * Set supports_checkpoints value
     * @param bool $supports_checkpoints
     * @return \StructType\Get_metadata_response
     */
    public function setSupports_checkpoints($supports_checkpoints = null)
    {
        // validation for constraint: boolean
        if (!is_null($supports_checkpoints) && !is_bool($supports_checkpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supports_checkpoints)), __LINE__);
        }
        $this->supports_checkpoints = $this->{'supports-checkpoints'} = $supports_checkpoints;
        return $this;
    }
    /**
     * Get MetadataEnumerations value
     * @return \StructType\MetaEnumList|null
     */
    public function getMetadataEnumerations()
    {
        return $this->MetadataEnumerations;
    }
    /**
     * Set MetadataEnumerations value
     * @param \StructType\MetaEnumList $metadataEnumerations
     * @return \StructType\Get_metadata_response
     */
    public function setMetadataEnumerations(\StructType\MetaEnumList $metadataEnumerations = null)
    {
        $this->MetadataEnumerations = $metadataEnumerations;
        return $this;
    }
    /**
     * Get Table value
     * @return \StructType\MetaTable[]|null
     */
    public function getTable()
    {
        return $this->Table;
    }
    /**
     * Set Table value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaTable[] $table
     * @return \StructType\Get_metadata_response
     */
    public function setTable(array $table = array())
    {
        foreach ($table as $get_metadata_responseTableItem) {
            // validation for constraint: itemType
            if (!$get_metadata_responseTableItem instanceof \StructType\MetaTable) {
                throw new \InvalidArgumentException(sprintf('The Table property can only contain items of \StructType\MetaTable, "%s" given', is_object($get_metadata_responseTableItem) ? get_class($get_metadata_responseTableItem) : gettype($get_metadata_responseTableItem)), __LINE__);
            }
        }
        $this->Table = $table;
        return $this;
    }
    /**
     * Add item to Table value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaTable $item
     * @return \StructType\Get_metadata_response
     */
    public function addToTable(\StructType\MetaTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MetaTable) {
            throw new \InvalidArgumentException(sprintf('The Table property can only contain items of \StructType\MetaTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Table[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Get_metadata_response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
