<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for get-checkpoint-response StructType
 * Meta informations extracted from the WSDL
 * - documentation: The response from the SetCheckpoint action which should contain the checkpoint data associated with the context parameters in the request.
 * @subpackage Structs
 */
class Get_checkpoint_response extends AbstractStructBase
{
    /**
     * The checkpoint_data
     * Meta informations extracted from the WSDL
     * - documentation: The checkpoint data associated with the request context parameters, and (if used) OAuth information. A checkpoint ID may be specified in the response so that subsequent set checkpoint actions maintain .
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CheckpointData
     */
    public $checkpoint_data;
    /**
     * Constructor method for get-checkpoint-response
     * @uses Get_checkpoint_response::setCheckpoint_data()
     * @param \StructType\CheckpointData $checkpoint_data
     */
    public function __construct(\StructType\CheckpointData $checkpoint_data = null)
    {
        $this
            ->setCheckpoint_data($checkpoint_data);
    }
    /**
     * Get checkpoint_data value
     * @return \StructType\CheckpointData
     */
    public function getCheckpoint_data()
    {
        return $this->{'checkpoint-data'};
    }
    /**
     * Set checkpoint_data value
     * @param \StructType\CheckpointData $checkpoint_data
     * @return \StructType\Get_checkpoint_response
     */
    public function setCheckpoint_data(\StructType\CheckpointData $checkpoint_data = null)
    {
        $this->checkpoint_data = $this->{'checkpoint-data'} = $checkpoint_data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Get_checkpoint_response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
