<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Field StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a field attribute in Table in the request of a Load or Save data action.
 * @subpackage Structs
 */
class Field extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the mapped Field.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The field_type
     * Meta informations extracted from the WSDL
     * - documentation: The data-type of the mapped Field.
     * - use: optional
     * @var string
     */
    public $field_type;
    /**
     * Constructor method for Field
     * @uses Field::setName()
     * @uses Field::setField_type()
     * @param string $name
     * @param string $field_type
     */
    public function __construct($name = null, $field_type = null)
    {
        $this
            ->setName($name)
            ->setField_type($field_type);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Field
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get field_type value
     * @return string|null
     */
    public function getField_type()
    {
        return $this->{'field-type'};
    }
    /**
     * Set field_type value
     * @uses \EnumType\AttributeTypeEnum::valueIsValid()
     * @uses \EnumType\AttributeTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $field_type
     * @return \StructType\Field
     */
    public function setField_type($field_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AttributeTypeEnum::valueIsValid($field_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $field_type, implode(', ', \EnumType\AttributeTypeEnum::getValidValues())), __LINE__);
        }
        $this->field_type = $this->{'field-type'} = $field_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Field
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
