<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityAuditNode StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the entity-node element of RelationshipAuditNode in the request of a Save data action.
 * @subpackage Structs
 */
class EntityAuditNode extends AbstractStructBase
{
    /**
     * The instance_id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier of the entity instance.
     * - use: required
     * @var string
     */
    public $instance_id;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: The text of the decision report for this node.
     * - use: required
     * @var string
     */
    public $text;
    /**
     * Constructor method for EntityAuditNode
     * @uses EntityAuditNode::setInstance_id()
     * @uses EntityAuditNode::setText()
     * @param string $instance_id
     * @param string $text
     */
    public function __construct($instance_id = null, $text = null)
    {
        $this
            ->setInstance_id($instance_id)
            ->setText($text);
    }
    /**
     * Get instance_id value
     * @return string
     */
    public function getInstance_id()
    {
        return $this->{'instance-id'};
    }
    /**
     * Set instance_id value
     * @param string $instance_id
     * @return \StructType\EntityAuditNode
     */
    public function setInstance_id($instance_id = null)
    {
        // validation for constraint: string
        if (!is_null($instance_id) && !is_string($instance_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instance_id)), __LINE__);
        }
        $this->instance_id = $this->{'instance-id'} = $instance_id;
        return $this;
    }
    /**
     * Get text value
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\EntityAuditNode
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityAuditNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
