<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateEnumeration StructType
 * @subpackage Structs
 */
class DateEnumeration extends AbstractStructBase
{
    /**
     * The EnumValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DateEnumVal[]
     */
    public $EnumValue;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The UncertainValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UncertainEnumVal
     */
    public $UncertainValue;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $description;
    /**
     * The child_enum_id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $child_enum_id;
    /**
     * Constructor method for DateEnumeration
     * @uses DateEnumeration::setEnumValue()
     * @uses DateEnumeration::setId()
     * @uses DateEnumeration::setUncertainValue()
     * @uses DateEnumeration::setDescription()
     * @uses DateEnumeration::setChild_enum_id()
     * @param \StructType\DateEnumVal[] $enumValue
     * @param string $id
     * @param \StructType\UncertainEnumVal $uncertainValue
     * @param string $description
     * @param string $child_enum_id
     */
    public function __construct(array $enumValue = array(), $id = null, \StructType\UncertainEnumVal $uncertainValue = null, $description = null, $child_enum_id = null)
    {
        $this
            ->setEnumValue($enumValue)
            ->setId($id)
            ->setUncertainValue($uncertainValue)
            ->setDescription($description)
            ->setChild_enum_id($child_enum_id);
    }
    /**
     * Get EnumValue value
     * @return \StructType\DateEnumVal[]
     */
    public function getEnumValue()
    {
        return $this->EnumValue;
    }
    /**
     * Set EnumValue value
     * @throws \InvalidArgumentException
     * @param \StructType\DateEnumVal[] $enumValue
     * @return \StructType\DateEnumeration
     */
    public function setEnumValue(array $enumValue = array())
    {
        foreach ($enumValue as $dateEnumerationEnumValueItem) {
            // validation for constraint: itemType
            if (!$dateEnumerationEnumValueItem instanceof \StructType\DateEnumVal) {
                throw new \InvalidArgumentException(sprintf('The EnumValue property can only contain items of \StructType\DateEnumVal, "%s" given', is_object($dateEnumerationEnumValueItem) ? get_class($dateEnumerationEnumValueItem) : gettype($dateEnumerationEnumValueItem)), __LINE__);
            }
        }
        $this->EnumValue = $enumValue;
        return $this;
    }
    /**
     * Add item to EnumValue value
     * @throws \InvalidArgumentException
     * @param \StructType\DateEnumVal $item
     * @return \StructType\DateEnumeration
     */
    public function addToEnumValue(\StructType\DateEnumVal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DateEnumVal) {
            throw new \InvalidArgumentException(sprintf('The EnumValue property can only contain items of \StructType\DateEnumVal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EnumValue[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DateEnumeration
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get UncertainValue value
     * @return \StructType\UncertainEnumVal|null
     */
    public function getUncertainValue()
    {
        return $this->UncertainValue;
    }
    /**
     * Set UncertainValue value
     * @param \StructType\UncertainEnumVal $uncertainValue
     * @return \StructType\DateEnumeration
     */
    public function setUncertainValue(\StructType\UncertainEnumVal $uncertainValue = null)
    {
        $this->UncertainValue = $uncertainValue;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DateEnumeration
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get child_enum_id value
     * @return string|null
     */
    public function getChild_enum_id()
    {
        return $this->{'child-enum-id'};
    }
    /**
     * Set child_enum_id value
     * @param string $child_enum_id
     * @return \StructType\DateEnumeration
     */
    public function setChild_enum_id($child_enum_id = null)
    {
        // validation for constraint: string
        if (!is_null($child_enum_id) && !is_string($child_enum_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($child_enum_id)), __LINE__);
        }
        $this->child_enum_id = $this->{'child-enum-id'} = $child_enum_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateEnumeration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
