<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataTable StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a table attribute in LoadData in the response of a Load data action.
 * @subpackage Structs
 */
class DataTable extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the table.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The row
     * Meta informations extracted from the WSDL
     * - documentation: An instance of the table.
     * - maxOccurs: unbounded
     * @var \StructType\DataRow[]
     */
    public $row;
    /**
     * Constructor method for DataTable
     * @uses DataTable::setName()
     * @uses DataTable::setRow()
     * @param string $name
     * @param \StructType\DataRow[] $row
     */
    public function __construct($name = null, array $row = array())
    {
        $this
            ->setName($name)
            ->setRow($row);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DataTable
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get row value
     * @return \StructType\DataRow[]|null
     */
    public function getRow()
    {
        return $this->row;
    }
    /**
     * Set row value
     * @throws \InvalidArgumentException
     * @param \StructType\DataRow[] $row
     * @return \StructType\DataTable
     */
    public function setRow(array $row = array())
    {
        foreach ($row as $dataTableRowItem) {
            // validation for constraint: itemType
            if (!$dataTableRowItem instanceof \StructType\DataRow) {
                throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\DataRow, "%s" given', is_object($dataTableRowItem) ? get_class($dataTableRowItem) : gettype($dataTableRowItem)), __LINE__);
            }
        }
        $this->row = $row;
        return $this;
    }
    /**
     * Add item to row value
     * @throws \InvalidArgumentException
     * @param \StructType\DataRow $item
     * @return \StructType\DataTable
     */
    public function addToRow(\StructType\DataRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataRow) {
            throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\DataRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->row[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataTable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
