<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataLink StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a link attribute in DataRow in the response of a Load, and in SubmitRow in the response of a Save data action.
 * @subpackage Structs
 */
class DataLink extends Link
{
    /**
     * The ref
     * Meta informations extracted from the WSDL
     * - documentation: A reference to a row of the target table.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LinkRef[]
     */
    public $ref;
    /**
     * Constructor method for DataLink
     * @uses DataLink::setRef()
     * @param \StructType\LinkRef[] $ref
     */
    public function __construct(array $ref = array())
    {
        $this
            ->setRef($ref);
    }
    /**
     * Get ref value
     * @return \StructType\LinkRef[]|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkRef[] $ref
     * @return \StructType\DataLink
     */
    public function setRef(array $ref = array())
    {
        foreach ($ref as $dataLinkRefItem) {
            // validation for constraint: itemType
            if (!$dataLinkRefItem instanceof \StructType\LinkRef) {
                throw new \InvalidArgumentException(sprintf('The ref property can only contain items of \StructType\LinkRef, "%s" given', is_object($dataLinkRefItem) ? get_class($dataLinkRefItem) : gettype($dataLinkRefItem)), __LINE__);
            }
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Add item to ref value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkRef $item
     * @return \StructType\DataLink
     */
    public function addToRef(\StructType\LinkRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinkRef) {
            throw new \InvalidArgumentException(sprintf('The ref property can only contain items of \StructType\LinkRef, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
