<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataField StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a field attribute in DataRow in the response of a Load, and for input-field and output-field in the SubmitRow in the request of a Save data action.Note that a DataField only has one of the following fields as a child node.
 * @subpackage Structs
 */
class DataField extends Field
{
    /**
     * The boolean_val
     * Meta informations extracted from the WSDL
     * - documentation: For boolean attributes, contains the value of the attribute
     * @var bool
     */
    public $boolean_val;
    /**
     * The date_val
     * Meta informations extracted from the WSDL
     * - documentation: For date attributes, contains the value of the attribute
     * @var string
     */
    public $date_val;
    /**
     * The datetime_val
     * Meta informations extracted from the WSDL
     * - documentation: For datetime attributes, contains the value of the attribute
     * @var string
     */
    public $datetime_val;
    /**
     * The time_val
     * Meta informations extracted from the WSDL
     * - documentation: For time attributes, contains the value of the attribute
     * @var string
     */
    public $time_val;
    /**
     * The number_val
     * Meta informations extracted from the WSDL
     * - documentation: For number or currency attributes, contains the value of the attribute
     * @var float
     */
    public $number_val;
    /**
     * The text_val
     * Meta informations extracted from the WSDL
     * - documentation: For text attributes, contains the value of the attribute
     * @var string
     */
    public $text_val;
    /**
     * The uncertain_val
     * Meta informations extracted from the WSDL
     * - documentation: For attributes of any type, this field is used when the attribute has the value uncertain
     * @var \StructType\UncertainValue
     */
    public $uncertain_val;
    /**
     * The unknown_val
     * Meta informations extracted from the WSDL
     * - documentation: For attributes of any type, this field is used when the attribute has the value unknown
     * @var \StructType\UnknownValue
     */
    public $unknown_val;
    /**
     * The change_point
     * Meta informations extracted from the WSDL
     * - documentation: Temporal change points for the attribute value
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangePoint[]
     */
    public $change_point;
    /**
     * Constructor method for DataField
     * @uses DataField::setBoolean_val()
     * @uses DataField::setDate_val()
     * @uses DataField::setDatetime_val()
     * @uses DataField::setTime_val()
     * @uses DataField::setNumber_val()
     * @uses DataField::setText_val()
     * @uses DataField::setUncertain_val()
     * @uses DataField::setUnknown_val()
     * @uses DataField::setChange_point()
     * @param bool $boolean_val
     * @param string $date_val
     * @param string $datetime_val
     * @param string $time_val
     * @param float $number_val
     * @param string $text_val
     * @param \StructType\UncertainValue $uncertain_val
     * @param \StructType\UnknownValue $unknown_val
     * @param \StructType\ChangePoint[] $change_point
     */
    public function __construct($boolean_val = null, $date_val = null, $datetime_val = null, $time_val = null, $number_val = null, $text_val = null, \StructType\UncertainValue $uncertain_val = null, \StructType\UnknownValue $unknown_val = null, array $change_point = array())
    {
        $this
            ->setBoolean_val($boolean_val)
            ->setDate_val($date_val)
            ->setDatetime_val($datetime_val)
            ->setTime_val($time_val)
            ->setNumber_val($number_val)
            ->setText_val($text_val)
            ->setUncertain_val($uncertain_val)
            ->setUnknown_val($unknown_val)
            ->setChange_point($change_point);
    }
    /**
     * Get boolean_val value
     * @return bool|null
     */
    public function getBoolean_val()
    {
        return $this->{'boolean-val'};
    }
    /**
     * Set boolean_val value
     * @param bool $boolean_val
     * @return \StructType\DataField
     */
    public function setBoolean_val($boolean_val = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolean_val) && !is_bool($boolean_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($boolean_val)), __LINE__);
        }
        $this->boolean_val = $this->{'boolean-val'} = $boolean_val;
        return $this;
    }
    /**
     * Get date_val value
     * @return string|null
     */
    public function getDate_val()
    {
        return $this->{'date-val'};
    }
    /**
     * Set date_val value
     * @param string $date_val
     * @return \StructType\DataField
     */
    public function setDate_val($date_val = null)
    {
        // validation for constraint: string
        if (!is_null($date_val) && !is_string($date_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_val)), __LINE__);
        }
        $this->date_val = $this->{'date-val'} = $date_val;
        return $this;
    }
    /**
     * Get datetime_val value
     * @return string|null
     */
    public function getDatetime_val()
    {
        return $this->{'datetime-val'};
    }
    /**
     * Set datetime_val value
     * @param string $datetime_val
     * @return \StructType\DataField
     */
    public function setDatetime_val($datetime_val = null)
    {
        // validation for constraint: string
        if (!is_null($datetime_val) && !is_string($datetime_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datetime_val)), __LINE__);
        }
        $this->datetime_val = $this->{'datetime-val'} = $datetime_val;
        return $this;
    }
    /**
     * Get time_val value
     * @return string|null
     */
    public function getTime_val()
    {
        return $this->{'time-val'};
    }
    /**
     * Set time_val value
     * @param string $time_val
     * @return \StructType\DataField
     */
    public function setTime_val($time_val = null)
    {
        // validation for constraint: string
        if (!is_null($time_val) && !is_string($time_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_val)), __LINE__);
        }
        $this->time_val = $this->{'time-val'} = $time_val;
        return $this;
    }
    /**
     * Get number_val value
     * @return float|null
     */
    public function getNumber_val()
    {
        return $this->{'number-val'};
    }
    /**
     * Set number_val value
     * @param float $number_val
     * @return \StructType\DataField
     */
    public function setNumber_val($number_val = null)
    {
        $this->number_val = $this->{'number-val'} = $number_val;
        return $this;
    }
    /**
     * Get text_val value
     * @return string|null
     */
    public function getText_val()
    {
        return $this->{'text-val'};
    }
    /**
     * Set text_val value
     * @param string $text_val
     * @return \StructType\DataField
     */
    public function setText_val($text_val = null)
    {
        // validation for constraint: string
        if (!is_null($text_val) && !is_string($text_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text_val)), __LINE__);
        }
        $this->text_val = $this->{'text-val'} = $text_val;
        return $this;
    }
    /**
     * Get uncertain_val value
     * @return \StructType\UncertainValue|null
     */
    public function getUncertain_val()
    {
        return $this->{'uncertain-val'};
    }
    /**
     * Set uncertain_val value
     * @param \StructType\UncertainValue $uncertain_val
     * @return \StructType\DataField
     */
    public function setUncertain_val(\StructType\UncertainValue $uncertain_val = null)
    {
        $this->uncertain_val = $this->{'uncertain-val'} = $uncertain_val;
        return $this;
    }
    /**
     * Get unknown_val value
     * @return \StructType\UnknownValue|null
     */
    public function getUnknown_val()
    {
        return $this->{'unknown-val'};
    }
    /**
     * Set unknown_val value
     * @param \StructType\UnknownValue $unknown_val
     * @return \StructType\DataField
     */
    public function setUnknown_val(\StructType\UnknownValue $unknown_val = null)
    {
        $this->unknown_val = $this->{'unknown-val'} = $unknown_val;
        return $this;
    }
    /**
     * Get change_point value
     * @return \StructType\ChangePoint[]|null
     */
    public function getChange_point()
    {
        return $this->{'change-point'};
    }
    /**
     * Set change_point value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangePoint[] $change_point
     * @return \StructType\DataField
     */
    public function setChange_point(array $change_point = array())
    {
        foreach ($change_point as $dataFieldChange_pointItem) {
            // validation for constraint: itemType
            if (!$dataFieldChange_pointItem instanceof \StructType\ChangePoint) {
                throw new \InvalidArgumentException(sprintf('The change_point property can only contain items of \StructType\ChangePoint, "%s" given', is_object($dataFieldChange_pointItem) ? get_class($dataFieldChange_pointItem) : gettype($dataFieldChange_pointItem)), __LINE__);
            }
        }
        $this->change_point = $this->{'change-point'} = $change_point;
        return $this;
    }
    /**
     */
    public function addToChange_point(\StructType\ChangePoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangePoint) {
            throw new \InvalidArgumentException(sprintf('The change_point property can only contain items of \StructType\ChangePoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->change_point[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
