<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckpointData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Checkpoint data (serialized interview session data) being sent to or retrieved from a Web Service Connector. This data will only be tagged with a checkpoint-id if a previous set or get checkpoint response specified one. | The Base64
 * encoded string of the checkpoint (serialized interview session) data.
 * @subpackage Structs
 */
class CheckpointData extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The checkpoint_id
     * Meta informations extracted from the WSDL
     * - documentation: The ID associated with the checkpoint. This is not generated by OPA so will be blank unless supplied by the WSC in a previous set or get checkpoint response.
     * - use: optional
     * @var string
     */
    public $checkpoint_id;
    /**
     * Constructor method for CheckpointData
     * @uses CheckpointData::set_()
     * @uses CheckpointData::setCheckpoint_id()
     * @param string $_
     * @param string $checkpoint_id
     */
    public function __construct($_ = null, $checkpoint_id = null)
    {
        $this
            ->set_($_)
            ->setCheckpoint_id($checkpoint_id);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\CheckpointData
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get checkpoint_id value
     * @return string|null
     */
    public function getCheckpoint_id()
    {
        return $this->{'checkpoint-id'};
    }
    /**
     * Set checkpoint_id value
     * @param string $checkpoint_id
     * @return \StructType\CheckpointData
     */
    public function setCheckpoint_id($checkpoint_id = null)
    {
        // validation for constraint: string
        if (!is_null($checkpoint_id) && !is_string($checkpoint_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkpoint_id)), __LINE__);
        }
        $this->checkpoint_id = $this->{'checkpoint-id'} = $checkpoint_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckpointData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
