<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangePoint StructType
 * Meta informations extracted from the WSDL
 * - documentation: Temporal change points for attribute values and decision report nodes provided to and returned from an Assess action.
 * @subpackage Structs
 */
class ChangePoint extends AbstractStructBase
{
    /**
     * The boolean_val
     * Meta informations extracted from the WSDL
     * - documentation: For boolean attributes, contains the value of the attribute. Must be set to either "true" or "false".
     * @var bool
     */
    public $boolean_val;
    /**
     * The date_val
     * Meta informations extracted from the WSDL
     * - documentation: For date attributes, contains the value of the attribute. Must be set to a valid date in the yyyy-mm-dd format. I.e. <year>-<month as two digit number>-<day of month as two digit number>
     * @var string
     */
    public $date_val;
    /**
     * The datetime_val
     * Meta informations extracted from the WSDL
     * - documentation: For datetime attributes, contains the value of the attribute. Must be a valid date and time in the timezone for the policy model, in the format yyyy-mm-ddThh:mm:ss format. I.e. <year>-<month as two digit number>-<day of
     * month>’T’<hours 00-23>:<minutes 00-59>:<seconds 00-59>
     * @var string
     */
    public $datetime_val;
    /**
     * The time_val
     * Meta informations extracted from the WSDL
     * - documentation: For time attributes, contains the value of the attribute. Must be a valid time in hh:mm:ss format. I.e. <hours 00-23>:<minutes 00-59>:<seconds 00-59>
     * @var string
     */
    public $time_val;
    /**
     * The number_val
     * Meta informations extracted from the WSDL
     * - documentation: For number or currency attributes, contains the value of the attribute
     * @var float
     */
    public $number_val;
    /**
     * The text_val
     * Meta informations extracted from the WSDL
     * - documentation: For text attributes, contains the value of the attribute
     * @var string
     */
    public $text_val;
    /**
     * The uncertain_val
     * Meta informations extracted from the WSDL
     * - documentation: For attributes of any type, this field is used when the attribute has the value uncertain
     * @var \StructType\UncertainValue
     */
    public $uncertain_val;
    /**
     * The unknown_val
     * Meta informations extracted from the WSDL
     * - documentation: For attributes of any type, this field is used when the attribute has the value unknown
     * @var \StructType\UnknownValue
     */
    public $unknown_val;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - documentation: date from which the new attribute value takes effect
     * @var string
     */
    public $date;
    /**
     * Constructor method for ChangePoint
     * @uses ChangePoint::setBoolean_val()
     * @uses ChangePoint::setDate_val()
     * @uses ChangePoint::setDatetime_val()
     * @uses ChangePoint::setTime_val()
     * @uses ChangePoint::setNumber_val()
     * @uses ChangePoint::setText_val()
     * @uses ChangePoint::setUncertain_val()
     * @uses ChangePoint::setUnknown_val()
     * @uses ChangePoint::setDate()
     * @param bool $boolean_val
     * @param string $date_val
     * @param string $datetime_val
     * @param string $time_val
     * @param float $number_val
     * @param string $text_val
     * @param \StructType\UncertainValue $uncertain_val
     * @param \StructType\UnknownValue $unknown_val
     * @param string $date
     */
    public function __construct($boolean_val = null, $date_val = null, $datetime_val = null, $time_val = null, $number_val = null, $text_val = null, \StructType\UncertainValue $uncertain_val = null, \StructType\UnknownValue $unknown_val = null, $date = null)
    {
        $this
            ->setBoolean_val($boolean_val)
            ->setDate_val($date_val)
            ->setDatetime_val($datetime_val)
            ->setTime_val($time_val)
            ->setNumber_val($number_val)
            ->setText_val($text_val)
            ->setUncertain_val($uncertain_val)
            ->setUnknown_val($unknown_val)
            ->setDate($date);
    }
    /**
     * Get boolean_val value
     * @return bool|null
     */
    public function getBoolean_val()
    {
        return $this->{'boolean-val'};
    }
    /**
     * Set boolean_val value
     * @param bool $boolean_val
     * @return \StructType\ChangePoint
     */
    public function setBoolean_val($boolean_val = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolean_val) && !is_bool($boolean_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($boolean_val)), __LINE__);
        }
        $this->boolean_val = $this->{'boolean-val'} = $boolean_val;
        return $this;
    }
    /**
     * Get date_val value
     * @return string|null
     */
    public function getDate_val()
    {
        return $this->{'date-val'};
    }
    /**
     * Set date_val value
     * @param string $date_val
     * @return \StructType\ChangePoint
     */
    public function setDate_val($date_val = null)
    {
        // validation for constraint: string
        if (!is_null($date_val) && !is_string($date_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_val)), __LINE__);
        }
        $this->date_val = $this->{'date-val'} = $date_val;
        return $this;
    }
    /**
     * Get datetime_val value
     * @return string|null
     */
    public function getDatetime_val()
    {
        return $this->{'datetime-val'};
    }
    /**
     * Set datetime_val value
     * @param string $datetime_val
     * @return \StructType\ChangePoint
     */
    public function setDatetime_val($datetime_val = null)
    {
        // validation for constraint: string
        if (!is_null($datetime_val) && !is_string($datetime_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datetime_val)), __LINE__);
        }
        $this->datetime_val = $this->{'datetime-val'} = $datetime_val;
        return $this;
    }
    /**
     * Get time_val value
     * @return string|null
     */
    public function getTime_val()
    {
        return $this->{'time-val'};
    }
    /**
     * Set time_val value
     * @param string $time_val
     * @return \StructType\ChangePoint
     */
    public function setTime_val($time_val = null)
    {
        // validation for constraint: string
        if (!is_null($time_val) && !is_string($time_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_val)), __LINE__);
        }
        $this->time_val = $this->{'time-val'} = $time_val;
        return $this;
    }
    /**
     * Get number_val value
     * @return float|null
     */
    public function getNumber_val()
    {
        return $this->{'number-val'};
    }
    /**
     * Set number_val value
     * @param float $number_val
     * @return \StructType\ChangePoint
     */
    public function setNumber_val($number_val = null)
    {
        $this->number_val = $this->{'number-val'} = $number_val;
        return $this;
    }
    /**
     * Get text_val value
     * @return string|null
     */
    public function getText_val()
    {
        return $this->{'text-val'};
    }
    /**
     * Set text_val value
     * @param string $text_val
     * @return \StructType\ChangePoint
     */
    public function setText_val($text_val = null)
    {
        // validation for constraint: string
        if (!is_null($text_val) && !is_string($text_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text_val)), __LINE__);
        }
        $this->text_val = $this->{'text-val'} = $text_val;
        return $this;
    }
    /**
     * Get uncertain_val value
     * @return \StructType\UncertainValue|null
     */
    public function getUncertain_val()
    {
        return $this->{'uncertain-val'};
    }
    /**
     * Set uncertain_val value
     * @param \StructType\UncertainValue $uncertain_val
     * @return \StructType\ChangePoint
     */
    public function setUncertain_val(\StructType\UncertainValue $uncertain_val = null)
    {
        $this->uncertain_val = $this->{'uncertain-val'} = $uncertain_val;
        return $this;
    }
    /**
     * Get unknown_val value
     * @return \StructType\UnknownValue|null
     */
    public function getUnknown_val()
    {
        return $this->{'unknown-val'};
    }
    /**
     * Set unknown_val value
     * @param \StructType\UnknownValue $unknown_val
     * @return \StructType\ChangePoint
     */
    public function setUnknown_val(\StructType\UnknownValue $unknown_val = null)
    {
        $this->unknown_val = $this->{'unknown-val'} = $unknown_val;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\ChangePoint
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
