<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeAuditNode StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the report attribute of AuditReportList, and for attribute-node of AttributeAuditNode in the request of a Save data action.
 * @subpackage Structs
 */
class AttributeAuditNode extends AbstractStructBase
{
    /**
     * The node_id
     * Meta informations extracted from the WSDL
     * - documentation: An identifier for the decision report node. When an attribute occurs more than once in a decision report, a reference is made to the first appearance by using this identifier.
     * - use: required
     * @var string
     */
    public $node_id;
    /**
     * The attribute_id
     * Meta informations extracted from the WSDL
     * - documentation: The name of the attribute for this decision report node
     * - use: required
     * @var string
     */
    public $attribute_id;
    /**
     * The attribute_type
     * Meta informations extracted from the WSDL
     * - documentation: The data type of the attribute for this decision report node
     * - use: required
     * @var string
     */
    public $attribute_type;
    /**
     * The entity_id
     * Meta informations extracted from the WSDL
     * - documentation: The name of the type of entity this attribute is contained in
     * - use: required
     * @var string
     */
    public $entity_id;
    /**
     * The instance_id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier of the entity instance for this attribute
     * - use: required
     * @var string
     */
    public $instance_id;
    /**
     * The is_user_set
     * Meta informations extracted from the WSDL
     * - documentation: The value of the attribute was set by the user
     * - use: required
     * @var bool
     */
    public $is_user_set;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: The text of the decision report for this node. For example "The child's serves of vegetables per day is 3." or "The child does not live at home."
     * - use: required
     * @var string
     */
    public $text;
    /**
     * The reference_tags
     * Meta informations extracted from the WSDL
     * - documentation: Contains the reference tags for this audit report node.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReferenceTagList
     */
    public $reference_tags;
    /**
     * The boolean_val
     * Meta informations extracted from the WSDL
     * - documentation: For boolean attributes, contains the value of the attribute
     * @var bool
     */
    public $boolean_val;
    /**
     * The date_val
     * Meta informations extracted from the WSDL
     * - documentation: For date attributes, contains the value of the attribute
     * @var string
     */
    public $date_val;
    /**
     * The datetime_val
     * Meta informations extracted from the WSDL
     * - documentation: For datetime attributes, contains the value of the attribute
     * @var string
     */
    public $datetime_val;
    /**
     * The time_val
     * Meta informations extracted from the WSDL
     * - documentation: For time attributes, contains the value of the attribute
     * @var string
     */
    public $time_val;
    /**
     * The number_val
     * Meta informations extracted from the WSDL
     * - documentation: For number or currency attributes, contains the value of the attribute
     * @var float
     */
    public $number_val;
    /**
     * The text_val
     * Meta informations extracted from the WSDL
     * - documentation: For text attributes, contains the value of the attribute
     * @var string
     */
    public $text_val;
    /**
     * The uncertain_val
     * Meta informations extracted from the WSDL
     * - documentation: For attributes of any type, this field is used when the attribute has the value uncertain
     * @var \StructType\UncertainValue
     */
    public $uncertain_val;
    /**
     * The unknown_val
     * Meta informations extracted from the WSDL
     * - documentation: For attributes of any type, this field is used when the attribute has the value unknown
     * @var \StructType\UnknownValue
     */
    public $unknown_val;
    /**
     * The change_point
     * Meta informations extracted from the WSDL
     * - documentation: When an attribute has temporal change points, these fields indicate where those change points occur
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangePoint[]
     */
    public $change_point;
    /**
     * The attribute_node
     * Meta informations extracted from the WSDL
     * - documentation: Decision report for another attribute that is relevant to the decision report for this attribute
     * @var \StructType\AttributeAuditNode
     */
    public $attribute_node;
    /**
     * The relationship_node
     * Meta informations extracted from the WSDL
     * - documentation: Decision report for a relationship that is relevant to the decision report for this attribute
     * @var \StructType\RelationshipAuditNode
     */
    public $relationship_node;
    /**
     * The already_proven_node
     * Meta informations extracted from the WSDL
     * - documentation: A cross-reference to another decision report node that is relevant to the decision report for this attribute
     * @var \StructType\ReferenceAuditNode
     */
    public $already_proven_node;
    /**
     * The start_relevance
     * Meta informations extracted from the WSDL
     * - documentation: If the relevance does not start at the beginning of time, the first date on which the attribute became relevant to the decision report. Can only be set if temporal rules or values are in use.
     * - use: optional
     * @var string
     */
    public $start_relevance;
    /**
     * The end_relevance
     * Meta informations extracted from the WSDL
     * - documentation: If the relevance does not continue to the end of time, the date on and after which the attribute was no longer relevant to the decision report. Can only be set if temporal rules or values are in use.
     * - use: optional
     * @var string
     */
    public $end_relevance;
    /**
     * Constructor method for AttributeAuditNode
     * @uses AttributeAuditNode::setNode_id()
     * @uses AttributeAuditNode::setAttribute_id()
     * @uses AttributeAuditNode::setAttribute_type()
     * @uses AttributeAuditNode::setEntity_id()
     * @uses AttributeAuditNode::setInstance_id()
     * @uses AttributeAuditNode::setIs_user_set()
     * @uses AttributeAuditNode::setText()
     * @uses AttributeAuditNode::setReference_tags()
     * @uses AttributeAuditNode::setBoolean_val()
     * @uses AttributeAuditNode::setDate_val()
     * @uses AttributeAuditNode::setDatetime_val()
     * @uses AttributeAuditNode::setTime_val()
     * @uses AttributeAuditNode::setNumber_val()
     * @uses AttributeAuditNode::setText_val()
     * @uses AttributeAuditNode::setUncertain_val()
     * @uses AttributeAuditNode::setUnknown_val()
     * @uses AttributeAuditNode::setChange_point()
     * @uses AttributeAuditNode::setAttribute_node()
     * @uses AttributeAuditNode::setRelationship_node()
     * @uses AttributeAuditNode::setAlready_proven_node()
     * @uses AttributeAuditNode::setStart_relevance()
     * @uses AttributeAuditNode::setEnd_relevance()
     * @param string $node_id
     * @param string $attribute_id
     * @param string $attribute_type
     * @param string $entity_id
     * @param string $instance_id
     * @param bool $is_user_set
     * @param string $text
     * @param \StructType\ReferenceTagList $reference_tags
     * @param bool $boolean_val
     * @param string $date_val
     * @param string $datetime_val
     * @param string $time_val
     * @param float $number_val
     * @param string $text_val
     * @param \StructType\UncertainValue $uncertain_val
     * @param \StructType\UnknownValue $unknown_val
     * @param \StructType\ChangePoint[] $change_point
     * @param \StructType\AttributeAuditNode $attribute_node
     * @param \StructType\RelationshipAuditNode $relationship_node
     * @param \StructType\ReferenceAuditNode $already_proven_node
     * @param string $start_relevance
     * @param string $end_relevance
     */
    public function __construct($node_id = null, $attribute_id = null, $attribute_type = null, $entity_id = null, $instance_id = null, $is_user_set = null, $text = null, \StructType\ReferenceTagList $reference_tags = null, $boolean_val = null, $date_val = null, $datetime_val = null, $time_val = null, $number_val = null, $text_val = null, \StructType\UncertainValue $uncertain_val = null, \StructType\UnknownValue $unknown_val = null, array $change_point = array(), \StructType\AttributeAuditNode $attribute_node = null, \StructType\RelationshipAuditNode $relationship_node = null, \StructType\ReferenceAuditNode $already_proven_node = null, $start_relevance = null, $end_relevance = null)
    {
        $this
            ->setNode_id($node_id)
            ->setAttribute_id($attribute_id)
            ->setAttribute_type($attribute_type)
            ->setEntity_id($entity_id)
            ->setInstance_id($instance_id)
            ->setIs_user_set($is_user_set)
            ->setText($text)
            ->setReference_tags($reference_tags)
            ->setBoolean_val($boolean_val)
            ->setDate_val($date_val)
            ->setDatetime_val($datetime_val)
            ->setTime_val($time_val)
            ->setNumber_val($number_val)
            ->setText_val($text_val)
            ->setUncertain_val($uncertain_val)
            ->setUnknown_val($unknown_val)
            ->setChange_point($change_point)
            ->setAttribute_node($attribute_node)
            ->setRelationship_node($relationship_node)
            ->setAlready_proven_node($already_proven_node)
            ->setStart_relevance($start_relevance)
            ->setEnd_relevance($end_relevance);
    }
    /**
     * Get node_id value
     * @return string
     */
    public function getNode_id()
    {
        return $this->{'node-id'};
    }
    /**
     * Set node_id value
     * @param string $node_id
     * @return \StructType\AttributeAuditNode
     */
    public function setNode_id($node_id = null)
    {
        // validation for constraint: string
        if (!is_null($node_id) && !is_string($node_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($node_id)), __LINE__);
        }
        $this->node_id = $this->{'node-id'} = $node_id;
        return $this;
    }
    /**
     * Get attribute_id value
     * @return string
     */
    public function getAttribute_id()
    {
        return $this->{'attribute-id'};
    }
    /**
     * Set attribute_id value
     * @param string $attribute_id
     * @return \StructType\AttributeAuditNode
     */
    public function setAttribute_id($attribute_id = null)
    {
        // validation for constraint: string
        if (!is_null($attribute_id) && !is_string($attribute_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attribute_id)), __LINE__);
        }
        $this->attribute_id = $this->{'attribute-id'} = $attribute_id;
        return $this;
    }
    /**
     * Get attribute_type value
     * @return string
     */
    public function getAttribute_type()
    {
        return $this->{'attribute-type'};
    }
    /**
     * Set attribute_type value
     * @uses \EnumType\AttributeTypeEnum::valueIsValid()
     * @uses \EnumType\AttributeTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attribute_type
     * @return \StructType\AttributeAuditNode
     */
    public function setAttribute_type($attribute_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AttributeTypeEnum::valueIsValid($attribute_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attribute_type, implode(', ', \EnumType\AttributeTypeEnum::getValidValues())), __LINE__);
        }
        $this->attribute_type = $this->{'attribute-type'} = $attribute_type;
        return $this;
    }
    /**
     * Get entity_id value
     * @return string
     */
    public function getEntity_id()
    {
        return $this->{'entity-id'};
    }
    /**
     * Set entity_id value
     * @param string $entity_id
     * @return \StructType\AttributeAuditNode
     */
    public function setEntity_id($entity_id = null)
    {
        // validation for constraint: string
        if (!is_null($entity_id) && !is_string($entity_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity_id)), __LINE__);
        }
        $this->entity_id = $this->{'entity-id'} = $entity_id;
        return $this;
    }
    /**
     * Get instance_id value
     * @return string
     */
    public function getInstance_id()
    {
        return $this->{'instance-id'};
    }
    /**
     * Set instance_id value
     * @param string $instance_id
     * @return \StructType\AttributeAuditNode
     */
    public function setInstance_id($instance_id = null)
    {
        // validation for constraint: string
        if (!is_null($instance_id) && !is_string($instance_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instance_id)), __LINE__);
        }
        $this->instance_id = $this->{'instance-id'} = $instance_id;
        return $this;
    }
    /**
     * Get is_user_set value
     * @return bool
     */
    public function getIs_user_set()
    {
        return $this->{'is-user-set'};
    }
    /**
     * Set is_user_set value
     * @param bool $is_user_set
     * @return \StructType\AttributeAuditNode
     */
    public function setIs_user_set($is_user_set = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_user_set) && !is_bool($is_user_set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_user_set)), __LINE__);
        }
        $this->is_user_set = $this->{'is-user-set'} = $is_user_set;
        return $this;
    }
    /**
     * Get text value
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\AttributeAuditNode
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get reference_tags value
     * @return \StructType\ReferenceTagList|null
     */
    public function getReference_tags()
    {
        return $this->{'reference-tags'};
    }
    /**
     * Set reference_tags value
     * @param \StructType\ReferenceTagList $reference_tags
     * @return \StructType\AttributeAuditNode
     */
    public function setReference_tags(\StructType\ReferenceTagList $reference_tags = null)
    {
        $this->reference_tags = $this->{'reference-tags'} = $reference_tags;
        return $this;
    }
    /**
     * Get boolean_val value
     * @return bool|null
     */
    public function getBoolean_val()
    {
        return $this->{'boolean-val'};
    }
    /**
     * Set boolean_val value
     * @param bool $boolean_val
     * @return \StructType\AttributeAuditNode
     */
    public function setBoolean_val($boolean_val = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolean_val) && !is_bool($boolean_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($boolean_val)), __LINE__);
        }
        $this->boolean_val = $this->{'boolean-val'} = $boolean_val;
        return $this;
    }
    /**
     * Get date_val value
     * @return string|null
     */
    public function getDate_val()
    {
        return $this->{'date-val'};
    }
    /**
     * Set date_val value
     * @param string $date_val
     * @return \StructType\AttributeAuditNode
     */
    public function setDate_val($date_val = null)
    {
        // validation for constraint: string
        if (!is_null($date_val) && !is_string($date_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_val)), __LINE__);
        }
        $this->date_val = $this->{'date-val'} = $date_val;
        return $this;
    }
    /**
     * Get datetime_val value
     * @return string|null
     */
    public function getDatetime_val()
    {
        return $this->{'datetime-val'};
    }
    /**
     * Set datetime_val value
     * @param string $datetime_val
     * @return \StructType\AttributeAuditNode
     */
    public function setDatetime_val($datetime_val = null)
    {
        // validation for constraint: string
        if (!is_null($datetime_val) && !is_string($datetime_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datetime_val)), __LINE__);
        }
        $this->datetime_val = $this->{'datetime-val'} = $datetime_val;
        return $this;
    }
    /**
     * Get time_val value
     * @return string|null
     */
    public function getTime_val()
    {
        return $this->{'time-val'};
    }
    /**
     * Set time_val value
     * @param string $time_val
     * @return \StructType\AttributeAuditNode
     */
    public function setTime_val($time_val = null)
    {
        // validation for constraint: string
        if (!is_null($time_val) && !is_string($time_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_val)), __LINE__);
        }
        $this->time_val = $this->{'time-val'} = $time_val;
        return $this;
    }
    /**
     * Get number_val value
     * @return float|null
     */
    public function getNumber_val()
    {
        return $this->{'number-val'};
    }
    /**
     * Set number_val value
     * @param float $number_val
     * @return \StructType\AttributeAuditNode
     */
    public function setNumber_val($number_val = null)
    {
        $this->number_val = $this->{'number-val'} = $number_val;
        return $this;
    }
    /**
     * Get text_val value
     * @return string|null
     */
    public function getText_val()
    {
        return $this->{'text-val'};
    }
    /**
     * Set text_val value
     * @param string $text_val
     * @return \StructType\AttributeAuditNode
     */
    public function setText_val($text_val = null)
    {
        // validation for constraint: string
        if (!is_null($text_val) && !is_string($text_val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text_val)), __LINE__);
        }
        $this->text_val = $this->{'text-val'} = $text_val;
        return $this;
    }
    /**
     * Get uncertain_val value
     * @return \StructType\UncertainValue|null
     */
    public function getUncertain_val()
    {
        return $this->{'uncertain-val'};
    }
    /**
     * Set uncertain_val value
     * @param \StructType\UncertainValue $uncertain_val
     * @return \StructType\AttributeAuditNode
     */
    public function setUncertain_val(\StructType\UncertainValue $uncertain_val = null)
    {
        $this->uncertain_val = $this->{'uncertain-val'} = $uncertain_val;
        return $this;
    }
    /**
     * Get unknown_val value
     * @return \StructType\UnknownValue|null
     */
    public function getUnknown_val()
    {
        return $this->{'unknown-val'};
    }
    /**
     * Set unknown_val value
     * @param \StructType\UnknownValue $unknown_val
     * @return \StructType\AttributeAuditNode
     */
    public function setUnknown_val(\StructType\UnknownValue $unknown_val = null)
    {
        $this->unknown_val = $this->{'unknown-val'} = $unknown_val;
        return $this;
    }
    /**
     * Get change_point value
     * @return \StructType\ChangePoint[]|null
     */
    public function getChange_point()
    {
        return $this->{'change-point'};
    }
    /**
     * Set change_point value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangePoint[] $change_point
     * @return \StructType\AttributeAuditNode
     */
    public function setChange_point(array $change_point = array())
    {
        foreach ($change_point as $attributeAuditNodeChange_pointItem) {
            // validation for constraint: itemType
            if (!$attributeAuditNodeChange_pointItem instanceof \StructType\ChangePoint) {
                throw new \InvalidArgumentException(sprintf('The change_point property can only contain items of \StructType\ChangePoint, "%s" given', is_object($attributeAuditNodeChange_pointItem) ? get_class($attributeAuditNodeChange_pointItem) : gettype($attributeAuditNodeChange_pointItem)), __LINE__);
            }
        }
        $this->change_point = $this->{'change-point'} = $change_point;
        return $this;
    }
    /**
     */
    public function addToChange_point(\StructType\ChangePoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangePoint) {
            throw new \InvalidArgumentException(sprintf('The change_point property can only contain items of \StructType\ChangePoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->change_point[] = $item;
        return $this;
    }
    /**
     * Get attribute_node value
     * @return \StructType\AttributeAuditNode|null
     */
    public function getAttribute_node()
    {
        return $this->{'attribute-node'};
    }
    /**
     * Set attribute_node value
     * @param \StructType\AttributeAuditNode $attribute_node
     * @return \StructType\AttributeAuditNode
     */
    public function setAttribute_node(\StructType\AttributeAuditNode $attribute_node = null)
    {
        $this->attribute_node = $this->{'attribute-node'} = $attribute_node;
        return $this;
    }
    /**
     * Get relationship_node value
     * @return \StructType\RelationshipAuditNode|null
     */
    public function getRelationship_node()
    {
        return $this->{'relationship-node'};
    }
    /**
     * Set relationship_node value
     * @param \StructType\RelationshipAuditNode $relationship_node
     * @return \StructType\AttributeAuditNode
     */
    public function setRelationship_node(\StructType\RelationshipAuditNode $relationship_node = null)
    {
        $this->relationship_node = $this->{'relationship-node'} = $relationship_node;
        return $this;
    }
    /**
     * Get already_proven_node value
     * @return \StructType\ReferenceAuditNode|null
     */
    public function getAlready_proven_node()
    {
        return $this->{'already-proven-node'};
    }
    /**
     * Set already_proven_node value
     * @param \StructType\ReferenceAuditNode $already_proven_node
     * @return \StructType\AttributeAuditNode
     */
    public function setAlready_proven_node(\StructType\ReferenceAuditNode $already_proven_node = null)
    {
        $this->already_proven_node = $this->{'already-proven-node'} = $already_proven_node;
        return $this;
    }
    /**
     * Get start_relevance value
     * @return string|null
     */
    public function getStart_relevance()
    {
        return $this->{'start-relevance'};
    }
    /**
     * Set start_relevance value
     * @param string $start_relevance
     * @return \StructType\AttributeAuditNode
     */
    public function setStart_relevance($start_relevance = null)
    {
        // validation for constraint: string
        if (!is_null($start_relevance) && !is_string($start_relevance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_relevance)), __LINE__);
        }
        $this->start_relevance = $this->{'start-relevance'} = $start_relevance;
        return $this;
    }
    /**
     * Get end_relevance value
     * @return string|null
     */
    public function getEnd_relevance()
    {
        return $this->{'end-relevance'};
    }
    /**
     * Set end_relevance value
     * @param string $end_relevance
     * @return \StructType\AttributeAuditNode
     */
    public function setEnd_relevance($end_relevance = null)
    {
        // validation for constraint: string
        if (!is_null($end_relevance) && !is_string($end_relevance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end_relevance)), __LINE__);
        }
        $this->end_relevance = $this->{'end-relevance'} = $end_relevance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributeAuditNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
