<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the attachment attribute of AttachmentList in the request of a Save data action. | Base64 encoded string of the attachment.
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the attachment.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - documentation: The filename of the attachment.
     * - use: required
     * @var string
     */
    public $filename;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the attachment. Forms have the description "Form auto generated by OPA.".
     * - use: required
     * @var string
     */
    public $description;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setName()
     * @uses Attachment::setFilename()
     * @uses Attachment::setDescription()
     * @uses Attachment::set_()
     * @param string $name
     * @param string $filename
     * @param string $description
     * @param string $_
     */
    public function __construct($name = null, $filename = null, $description = null, $_ = null)
    {
        $this
            ->setName($name)
            ->setFilename($filename)
            ->setDescription($description)
            ->set_($_);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Attachment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get filename value
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\Attachment
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Attachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Attachment
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
