<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Load
     * Meta informations extracted from the WSDL
     * - documentation: This action is sent at the start of an interview to request data for each of the tables, links and attributes which were mapped to in a policy model. The response returned by the web service connector is expected to contain values
     * for each of the requested items.The web service will receive a SOAPAction of Load with a security header (if the connection was configured with a username and password) with information about the policy model such as the global input table,
     * localization information, tables, links and attributes which were mapped, and any additional parameters that may have been specified by the start session url. The response must not contain any tables, links or fields which were listed in the request,
     * or the interview will fail to start and the error will be logged. | If the response of a Load action contains unexpected values or structure will be logged. Depending on the severity of the issue, the interview may fail to start, be aware that an
     * interview that starts did not necessarily start without errors.If an error is raised by the web service connector, the body of the response may instead consist of a RequestFault. This defined fault structure allows the Hub log display the error in a
     * cleaner format, as opposed to a stack trace.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Load_request $request
     * @return \StructType\Load_response|bool
     */
    public function Load(\StructType\Load_request $request)
    {
        try {
            $this->setResult(self::getSoapClient()->Load($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Load_response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
