<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetMetadata
     * Meta informations extracted from the WSDL
     * - documentation: The metadata action will have a SOAPAction of GetMetadata. The Security header will be included if the web service connection was configured in Policy Automation Hub with a username and password, and must be understood by the web
     * service. The body of the request will contain an empty element named languageCodewith the namespace http://xmlns.oracle.com/policyautomation/hub/12.2.2/metadata/types. The only information supplied in the request is the language used in the project,
     * which may be utilized by the web service connector to include descriptions of metadata elements in that language. The response must contain all of the metadata which is available for Policy Modeling to map attributes, tables and relationships to.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_metadata_request $request
     * @return \StructType\Get_metadata_response|bool
     */
    public function GetMetadata(\StructType\Get_metadata_request $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMetadata($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCheckpoint
     * Meta informations extracted from the WSDL
     * - documentation: The GetCheckpoint action may be called to retrieve checkpoint (serialized interview session) data. This data should have previously been stored as the result of a SetCheckpoint request and should be retrieved using the request
     * parameters and (if used) an OAuth token. Once returned, if the deserialized session data matches the deployed rulebase the session will be resumed. If the checkpoint data can not be retrieved by the Web Service Connector for whatever reason a
     * RequestFault should be returned to explain the cause. | If the response of a GetCheckpoint action contains unexpected values or structure the response will be logged.If an error is raised by the web service connector, the body of the response may
     * instead consist of a RequestFault. This defined fault structure allows the Hub log display the error in a cleaner format, as opposed to a stack trace.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_checkpoint_request $request
     * @return \StructType\Get_checkpoint_response|bool
     */
    public function GetCheckpoint(\StructType\Get_checkpoint_request $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCheckpoint($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_checkpoint_response|\StructType\Get_metadata_response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
