<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckAlive
     * Meta informations extracted from the WSDL
     * - documentation: This action allows Policy Automation Hub to check whether the web service connector is online and responding satisfactorily to the credentials that the web service connection has been configured with.The web service will receive a
     * SOAPAction of CheckAlive with a Security header (if the connection was configured with a username and password), and the body will contain an empty element named check-alive-request with the namespace
     * http://xmlns.oracle.com/policyautomation/hub/12.2.2/metadata/types.The web service receiving the request should parse the request and verify the credentials within the security header. If the credentials do not pass, the response should be an error
     * such as HTTP 401 Unauthorized. The response is expected to be an HTTP 200 OK with the body containing an empty element named check-alive-response if the service accepts the username and password supplied. Otherwise Policy Automation Hub will
     * interpret the response, or lack of response, as an offline web service connection and will display the connection as Failing in the Connections tab on Policy Automation Hub.The CheckAlive method provides a means for a Hub to establish that a web
     * service connector is running.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Check_alive_request $request
     * @return \StructType\Check_alive_response|bool
     */
    public function CheckAlive(\StructType\Check_alive_request $request)
    {
        try {
            $this->setResult(self::getSoapClient()->CheckAlive($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Check_alive_response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
