<?php

namespace EnumType;

/**
 * This class stands for StateEnum EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The supported state types for relationships provided to and returned from an Save data action.
 * @subpackage Enumerations
 */
class StateEnum
{
    /**
     * Constant for value 'known'
     * @return string 'known'
     */
    const VALUE_KNOWN = 'known';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'uncertain'
     * @return string 'uncertain'
     */
    const VALUE_UNCERTAIN = 'uncertain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KNOWN
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_UNCERTAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KNOWN,
            self::VALUE_UNKNOWN,
            self::VALUE_UNCERTAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
