<?php

namespace EnumType;

/**
 * This class stands for RelationshipCardinalityEnum EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The supported cardinality types for relationships provided to and returned from a Save data action.
 * @subpackage Enumerations
 */
class RelationshipCardinalityEnum
{
    /**
     * Constant for value 'OneToOne'
     * @return string 'OneToOne'
     */
    const VALUE_ONE_TO_ONE = 'OneToOne';
    /**
     * Constant for value 'OneToMany'
     * @return string 'OneToMany'
     */
    const VALUE_ONE_TO_MANY = 'OneToMany';
    /**
     * Constant for value 'ManyToOne'
     * @return string 'ManyToOne'
     */
    const VALUE_MANY_TO_ONE = 'ManyToOne';
    /**
     * Constant for value 'ManyToMany'
     * @return string 'ManyToMany'
     */
    const VALUE_MANY_TO_MANY = 'ManyToMany';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONE_TO_ONE
     * @uses self::VALUE_ONE_TO_MANY
     * @uses self::VALUE_MANY_TO_ONE
     * @uses self::VALUE_MANY_TO_MANY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONE_TO_ONE,
            self::VALUE_ONE_TO_MANY,
            self::VALUE_MANY_TO_ONE,
            self::VALUE_MANY_TO_MANY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
