<?php

namespace EnumType;

/**
 * This class stands for MetaLinkCardinality EnumType
 * Meta informations extracted from the WSDL
 * - documentation: xsd:string enumeration for an attribute of MetaLink in the metadata response of a GetMetadata action.
 * @subpackage Enumerations
 */
class MetaLinkCardinality
{
    /**
     * Constant for value 'C_11'
     * @return string 'C_11'
     */
    const VALUE_C_11 = 'C_11';
    /**
     * Constant for value 'C_1M'
     * @return string 'C_1M'
     */
    const VALUE_C_1_M = 'C_1M';
    /**
     * Constant for value 'C_M1'
     * @return string 'C_M1'
     */
    const VALUE_C_M_1 = 'C_M1';
    /**
     * Constant for value 'C_MN'
     * @return string 'C_MN'
     */
    const VALUE_C_MN = 'C_MN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_C_11
     * @uses self::VALUE_C_1_M
     * @uses self::VALUE_C_M_1
     * @uses self::VALUE_C_MN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_C_11,
            self::VALUE_C_1_M,
            self::VALUE_C_M_1,
            self::VALUE_C_MN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
