<?php

namespace EnumType;

/**
 * This class stands for MetaFieldDataType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration for an attribute of MetaField in the metadata response of a GetMetadata action.
 * @subpackage Enumerations
 */
class MetaFieldDataType
{
    /**
     * Constant for value 'STRING'
     * @return string 'STRING'
     */
    const VALUE_STRING = 'STRING';
    /**
     * Constant for value 'DATETIME'
     * @return string 'DATETIME'
     */
    const VALUE_DATETIME = 'DATETIME';
    /**
     * Constant for value 'BOOLEAN'
     * @return string 'BOOLEAN'
     */
    const VALUE_BOOLEAN = 'BOOLEAN';
    /**
     * Constant for value 'DATE'
     * @return string 'DATE'
     */
    const VALUE_DATE = 'DATE';
    /**
     * Constant for value 'DECIMAL'
     * @return string 'DECIMAL'
     */
    const VALUE_DECIMAL = 'DECIMAL';
    /**
     * Constant for value 'TIMEOFDAY'
     * @return string 'TIMEOFDAY'
     */
    const VALUE_TIMEOFDAY = 'TIMEOFDAY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRING
     * @uses self::VALUE_DATETIME
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_DATE
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_TIMEOFDAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRING,
            self::VALUE_DATETIME,
            self::VALUE_BOOLEAN,
            self::VALUE_DATE,
            self::VALUE_DECIMAL,
            self::VALUE_TIMEOFDAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
