<?php

namespace EnumType;

/**
 * This class stands for AttributeTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The supported data types for attributes provided to and returned from an Save data action.
 * @subpackage Enumerations
 */
class AttributeTypeEnum
{
    /**
     * Constant for value 'boolean'
     * @return string 'boolean'
     */
    const VALUE_BOOLEAN = 'boolean';
    /**
     * Constant for value 'text'
     * @return string 'text'
     */
    const VALUE_TEXT = 'text';
    /**
     * Constant for value 'number'
     * @return string 'number'
     */
    const VALUE_NUMBER = 'number';
    /**
     * Constant for value 'currency'
     * @return string 'currency'
     */
    const VALUE_CURRENCY = 'currency';
    /**
     * Constant for value 'date'
     * @return string 'date'
     */
    const VALUE_DATE = 'date';
    /**
     * Constant for value 'datetime'
     * @return string 'datetime'
     */
    const VALUE_DATETIME = 'datetime';
    /**
     * Constant for value 'timeofday'
     * @return string 'timeofday'
     */
    const VALUE_TIMEOFDAY = 'timeofday';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_NUMBER
     * @uses self::VALUE_CURRENCY
     * @uses self::VALUE_DATE
     * @uses self::VALUE_DATETIME
     * @uses self::VALUE_TIMEOFDAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOOLEAN,
            self::VALUE_TEXT,
            self::VALUE_NUMBER,
            self::VALUE_CURRENCY,
            self::VALUE_DATE,
            self::VALUE_DATETIME,
            self::VALUE_TIMEOFDAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
