<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Services StructType
 * @subpackage Structs
 */
class Services extends AbstractStructBase
{
    /**
     * The eveningDelivery
     * @var bool
     */
    public $eveningDelivery;
    /**
     * The householdSignature
     * @var bool
     */
    public $householdSignature;
    /**
     * The nextDay
     * @var int
     */
    public $nextDay;
    /**
     * The signature
     * @var bool
     */
    public $signature;
    /**
     * The redirectionProhibited
     * @var bool
     */
    public $redirectionProhibited;
    /**
     * The customerAlert
     * @var int
     */
    public $customerAlert;
    /**
     * The statedDay
     * @var int
     */
    public $statedDay;
    /**
     * The statedTime
     * @var int
     */
    public $statedTime;
    /**
     * The multipleParts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $multipleParts;
    /**
     * The limitedQuantity
     * @var bool
     */
    public $limitedQuantity;
    /**
     * The customerPhoneAlert
     * @var int
     */
    public $customerPhoneAlert;
    /**
     * The consigned
     * @var bool
     */
    public $consigned;
    /**
     * The consignedPIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $consignedPIN;
    /**
     * The customerAlertGroup
     * @var int
     */
    public $customerAlertGroup;
    /**
     * The storeDelivery
     * @var bool
     */
    public $storeDelivery;
    /**
     * The cashOnDelivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CashOnDelivery
     */
    public $cashOnDelivery;
    /**
     * The parcelshopDelivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParcelshopDelivery
     */
    public $parcelshopDelivery;
    /**
     * The identService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentService
     */
    public $identService;
    /**
     * Constructor method for Services
     * @uses Services::setEveningDelivery()
     * @uses Services::setHouseholdSignature()
     * @uses Services::setNextDay()
     * @uses Services::setSignature()
     * @uses Services::setRedirectionProhibited()
     * @uses Services::setCustomerAlert()
     * @uses Services::setStatedDay()
     * @uses Services::setStatedTime()
     * @uses Services::setMultipleParts()
     * @uses Services::setLimitedQuantity()
     * @uses Services::setCustomerPhoneAlert()
     * @uses Services::setConsigned()
     * @uses Services::setConsignedPIN()
     * @uses Services::setCustomerAlertGroup()
     * @uses Services::setStoreDelivery()
     * @uses Services::setCashOnDelivery()
     * @uses Services::setParcelshopDelivery()
     * @uses Services::setIdentService()
     * @param bool $eveningDelivery
     * @param bool $householdSignature
     * @param int $nextDay
     * @param bool $signature
     * @param bool $redirectionProhibited
     * @param int $customerAlert
     * @param int $statedDay
     * @param int $statedTime
     * @param string $multipleParts
     * @param bool $limitedQuantity
     * @param int $customerPhoneAlert
     * @param bool $consigned
     * @param int $consignedPIN
     * @param int $customerAlertGroup
     * @param bool $storeDelivery
     * @param \StructType\CashOnDelivery $cashOnDelivery
     * @param \StructType\ParcelshopDelivery $parcelshopDelivery
     * @param \StructType\IdentService $identService
     */
    public function __construct($eveningDelivery = null, $householdSignature = null, $nextDay = null, $signature = null, $redirectionProhibited = null, $customerAlert = null, $statedDay = null, $statedTime = null, $multipleParts = null, $limitedQuantity = null, $customerPhoneAlert = null, $consigned = null, $consignedPIN = null, $customerAlertGroup = null, $storeDelivery = null, \StructType\CashOnDelivery $cashOnDelivery = null, \StructType\ParcelshopDelivery $parcelshopDelivery = null, \StructType\IdentService $identService = null)
    {
        $this
            ->setEveningDelivery($eveningDelivery)
            ->setHouseholdSignature($householdSignature)
            ->setNextDay($nextDay)
            ->setSignature($signature)
            ->setRedirectionProhibited($redirectionProhibited)
            ->setCustomerAlert($customerAlert)
            ->setStatedDay($statedDay)
            ->setStatedTime($statedTime)
            ->setMultipleParts($multipleParts)
            ->setLimitedQuantity($limitedQuantity)
            ->setCustomerPhoneAlert($customerPhoneAlert)
            ->setConsigned($consigned)
            ->setConsignedPIN($consignedPIN)
            ->setCustomerAlertGroup($customerAlertGroup)
            ->setStoreDelivery($storeDelivery)
            ->setCashOnDelivery($cashOnDelivery)
            ->setParcelshopDelivery($parcelshopDelivery)
            ->setIdentService($identService);
    }
    /**
     * Get eveningDelivery value
     * @return bool|null
     */
    public function getEveningDelivery()
    {
        return $this->eveningDelivery;
    }
    /**
     * Set eveningDelivery value
     * @param bool $eveningDelivery
     * @return \StructType\Services
     */
    public function setEveningDelivery($eveningDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($eveningDelivery) && !is_bool($eveningDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($eveningDelivery)), __LINE__);
        }
        $this->eveningDelivery = $eveningDelivery;
        return $this;
    }
    /**
     * Get householdSignature value
     * @return bool|null
     */
    public function getHouseholdSignature()
    {
        return $this->householdSignature;
    }
    /**
     * Set householdSignature value
     * @param bool $householdSignature
     * @return \StructType\Services
     */
    public function setHouseholdSignature($householdSignature = null)
    {
        // validation for constraint: boolean
        if (!is_null($householdSignature) && !is_bool($householdSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($householdSignature)), __LINE__);
        }
        $this->householdSignature = $householdSignature;
        return $this;
    }
    /**
     * Get nextDay value
     * @return int|null
     */
    public function getNextDay()
    {
        return $this->nextDay;
    }
    /**
     * Set nextDay value
     * @param int $nextDay
     * @return \StructType\Services
     */
    public function setNextDay($nextDay = null)
    {
        // validation for constraint: int
        if (!is_null($nextDay) && !is_numeric($nextDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nextDay)), __LINE__);
        }
        $this->nextDay = $nextDay;
        return $this;
    }
    /**
     * Get signature value
     * @return bool|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param bool $signature
     * @return \StructType\Services
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: boolean
        if (!is_null($signature) && !is_bool($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($signature)), __LINE__);
        }
        $this->signature = $signature;
        return $this;
    }
    /**
     * Get redirectionProhibited value
     * @return bool|null
     */
    public function getRedirectionProhibited()
    {
        return $this->redirectionProhibited;
    }
    /**
     * Set redirectionProhibited value
     * @param bool $redirectionProhibited
     * @return \StructType\Services
     */
    public function setRedirectionProhibited($redirectionProhibited = null)
    {
        // validation for constraint: boolean
        if (!is_null($redirectionProhibited) && !is_bool($redirectionProhibited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($redirectionProhibited)), __LINE__);
        }
        $this->redirectionProhibited = $redirectionProhibited;
        return $this;
    }
    /**
     * Get customerAlert value
     * @return int|null
     */
    public function getCustomerAlert()
    {
        return $this->customerAlert;
    }
    /**
     * Set customerAlert value
     * @param int $customerAlert
     * @return \StructType\Services
     */
    public function setCustomerAlert($customerAlert = null)
    {
        // validation for constraint: int
        if (!is_null($customerAlert) && !is_numeric($customerAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerAlert)), __LINE__);
        }
        $this->customerAlert = $customerAlert;
        return $this;
    }
    /**
     * Get statedDay value
     * @return int|null
     */
    public function getStatedDay()
    {
        return $this->statedDay;
    }
    /**
     * Set statedDay value
     * @param int $statedDay
     * @return \StructType\Services
     */
    public function setStatedDay($statedDay = null)
    {
        // validation for constraint: int
        if (!is_null($statedDay) && !is_numeric($statedDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statedDay)), __LINE__);
        }
        $this->statedDay = $statedDay;
        return $this;
    }
    /**
     * Get statedTime value
     * @return int|null
     */
    public function getStatedTime()
    {
        return $this->statedTime;
    }
    /**
     * Set statedTime value
     * @param int $statedTime
     * @return \StructType\Services
     */
    public function setStatedTime($statedTime = null)
    {
        // validation for constraint: int
        if (!is_null($statedTime) && !is_numeric($statedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statedTime)), __LINE__);
        }
        $this->statedTime = $statedTime;
        return $this;
    }
    /**
     * Get multipleParts value
     * @return string|null
     */
    public function getMultipleParts()
    {
        return $this->multipleParts;
    }
    /**
     * Set multipleParts value
     * @param string $multipleParts
     * @return \StructType\Services
     */
    public function setMultipleParts($multipleParts = null)
    {
        // validation for constraint: string
        if (!is_null($multipleParts) && !is_string($multipleParts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multipleParts)), __LINE__);
        }
        $this->multipleParts = $multipleParts;
        return $this;
    }
    /**
     * Get limitedQuantity value
     * @return bool|null
     */
    public function getLimitedQuantity()
    {
        return $this->limitedQuantity;
    }
    /**
     * Set limitedQuantity value
     * @param bool $limitedQuantity
     * @return \StructType\Services
     */
    public function setLimitedQuantity($limitedQuantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitedQuantity) && !is_bool($limitedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($limitedQuantity)), __LINE__);
        }
        $this->limitedQuantity = $limitedQuantity;
        return $this;
    }
    /**
     * Get customerPhoneAlert value
     * @return int|null
     */
    public function getCustomerPhoneAlert()
    {
        return $this->customerPhoneAlert;
    }
    /**
     * Set customerPhoneAlert value
     * @param int $customerPhoneAlert
     * @return \StructType\Services
     */
    public function setCustomerPhoneAlert($customerPhoneAlert = null)
    {
        // validation for constraint: int
        if (!is_null($customerPhoneAlert) && !is_numeric($customerPhoneAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerPhoneAlert)), __LINE__);
        }
        $this->customerPhoneAlert = $customerPhoneAlert;
        return $this;
    }
    /**
     * Get consigned value
     * @return bool|null
     */
    public function getConsigned()
    {
        return $this->consigned;
    }
    /**
     * Set consigned value
     * @param bool $consigned
     * @return \StructType\Services
     */
    public function setConsigned($consigned = null)
    {
        // validation for constraint: boolean
        if (!is_null($consigned) && !is_bool($consigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($consigned)), __LINE__);
        }
        $this->consigned = $consigned;
        return $this;
    }
    /**
     * Get consignedPIN value
     * @return int|null
     */
    public function getConsignedPIN()
    {
        return $this->consignedPIN;
    }
    /**
     * Set consignedPIN value
     * @param int $consignedPIN
     * @return \StructType\Services
     */
    public function setConsignedPIN($consignedPIN = null)
    {
        // validation for constraint: int
        if (!is_null($consignedPIN) && !is_numeric($consignedPIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consignedPIN)), __LINE__);
        }
        $this->consignedPIN = $consignedPIN;
        return $this;
    }
    /**
     * Get customerAlertGroup value
     * @return int|null
     */
    public function getCustomerAlertGroup()
    {
        return $this->customerAlertGroup;
    }
    /**
     * Set customerAlertGroup value
     * @param int $customerAlertGroup
     * @return \StructType\Services
     */
    public function setCustomerAlertGroup($customerAlertGroup = null)
    {
        // validation for constraint: int
        if (!is_null($customerAlertGroup) && !is_numeric($customerAlertGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerAlertGroup)), __LINE__);
        }
        $this->customerAlertGroup = $customerAlertGroup;
        return $this;
    }
    /**
     * Get storeDelivery value
     * @return bool|null
     */
    public function getStoreDelivery()
    {
        return $this->storeDelivery;
    }
    /**
     * Set storeDelivery value
     * @param bool $storeDelivery
     * @return \StructType\Services
     */
    public function setStoreDelivery($storeDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($storeDelivery) && !is_bool($storeDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($storeDelivery)), __LINE__);
        }
        $this->storeDelivery = $storeDelivery;
        return $this;
    }
    /**
     * Get cashOnDelivery value
     * @return \StructType\CashOnDelivery|null
     */
    public function getCashOnDelivery()
    {
        return $this->cashOnDelivery;
    }
    /**
     * Set cashOnDelivery value
     * @param \StructType\CashOnDelivery $cashOnDelivery
     * @return \StructType\Services
     */
    public function setCashOnDelivery(\StructType\CashOnDelivery $cashOnDelivery = null)
    {
        $this->cashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get parcelshopDelivery value
     * @return \StructType\ParcelshopDelivery|null
     */
    public function getParcelshopDelivery()
    {
        return $this->parcelshopDelivery;
    }
    /**
     * Set parcelshopDelivery value
     * @param \StructType\ParcelshopDelivery $parcelshopDelivery
     * @return \StructType\Services
     */
    public function setParcelshopDelivery(\StructType\ParcelshopDelivery $parcelshopDelivery = null)
    {
        $this->parcelshopDelivery = $parcelshopDelivery;
        return $this;
    }
    /**
     * Get identService value
     * @return \StructType\IdentService|null
     */
    public function getIdentService()
    {
        return $this->identService;
    }
    /**
     * Set identService value
     * @param \StructType\IdentService $identService
     * @return \StructType\Services
     */
    public function setIdentService(\StructType\IdentService $identService = null)
    {
        $this->identService = $identService;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Services
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
