<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDescription StructType
 * @subpackage Structs
 */
class ServiceDescription extends AbstractStructBase
{
    /**
     * The serviceDescriptionText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceDescriptionText;
    /**
     * The serviceLogoRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceLogoRef;
    /**
     * The servicePosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $servicePosition;
    /**
     * Constructor method for ServiceDescription
     * @uses ServiceDescription::setServiceDescriptionText()
     * @uses ServiceDescription::setServiceLogoRef()
     * @uses ServiceDescription::setServicePosition()
     * @param string $serviceDescriptionText
     * @param string $serviceLogoRef
     * @param int $servicePosition
     */
    public function __construct($serviceDescriptionText = null, $serviceLogoRef = null, $servicePosition = null)
    {
        $this
            ->setServiceDescriptionText($serviceDescriptionText)
            ->setServiceLogoRef($serviceLogoRef)
            ->setServicePosition($servicePosition);
    }
    /**
     * Get serviceDescriptionText value
     * @return string|null
     */
    public function getServiceDescriptionText()
    {
        return $this->serviceDescriptionText;
    }
    /**
     * Set serviceDescriptionText value
     * @param string $serviceDescriptionText
     * @return \StructType\ServiceDescription
     */
    public function setServiceDescriptionText($serviceDescriptionText = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescriptionText) && !is_string($serviceDescriptionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDescriptionText)), __LINE__);
        }
        $this->serviceDescriptionText = $serviceDescriptionText;
        return $this;
    }
    /**
     * Get serviceLogoRef value
     * @return string|null
     */
    public function getServiceLogoRef()
    {
        return $this->serviceLogoRef;
    }
    /**
     * Set serviceLogoRef value
     * @param string $serviceLogoRef
     * @return \StructType\ServiceDescription
     */
    public function setServiceLogoRef($serviceLogoRef = null)
    {
        // validation for constraint: string
        if (!is_null($serviceLogoRef) && !is_string($serviceLogoRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceLogoRef)), __LINE__);
        }
        $this->serviceLogoRef = $serviceLogoRef;
        return $this;
    }
    /**
     * Get servicePosition value
     * @return int|null
     */
    public function getServicePosition()
    {
        return $this->servicePosition;
    }
    /**
     * Set servicePosition value
     * @param int $servicePosition
     * @return \StructType\ServiceDescription
     */
    public function setServicePosition($servicePosition = null)
    {
        // validation for constraint: int
        if (!is_null($servicePosition) && !is_numeric($servicePosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePosition)), __LINE__);
        }
        $this->servicePosition = $servicePosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
