<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for routingVersion StructType
 * @subpackage Structs
 */
class RoutingVersion extends AbstractStructBase
{
    /**
     * The routingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routingCarrier;
    /**
     * The routingVersionActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routingVersionActive;
    /**
     * The routingVersionImported
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routingVersionImported;
    /**
     * Constructor method for routingVersion
     * @uses RoutingVersion::setRoutingCarrier()
     * @uses RoutingVersion::setRoutingVersionActive()
     * @uses RoutingVersion::setRoutingVersionImported()
     * @param string $routingCarrier
     * @param string $routingVersionActive
     * @param string $routingVersionImported
     */
    public function __construct($routingCarrier = null, $routingVersionActive = null, $routingVersionImported = null)
    {
        $this
            ->setRoutingCarrier($routingCarrier)
            ->setRoutingVersionActive($routingVersionActive)
            ->setRoutingVersionImported($routingVersionImported);
    }
    /**
     * Get routingCarrier value
     * @return string|null
     */
    public function getRoutingCarrier()
    {
        return $this->routingCarrier;
    }
    /**
     * Set routingCarrier value
     * @param string $routingCarrier
     * @return \StructType\RoutingVersion
     */
    public function setRoutingCarrier($routingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($routingCarrier) && !is_string($routingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingCarrier)), __LINE__);
        }
        $this->routingCarrier = $routingCarrier;
        return $this;
    }
    /**
     * Get routingVersionActive value
     * @return string|null
     */
    public function getRoutingVersionActive()
    {
        return $this->routingVersionActive;
    }
    /**
     * Set routingVersionActive value
     * @param string $routingVersionActive
     * @return \StructType\RoutingVersion
     */
    public function setRoutingVersionActive($routingVersionActive = null)
    {
        // validation for constraint: string
        if (!is_null($routingVersionActive) && !is_string($routingVersionActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingVersionActive)), __LINE__);
        }
        $this->routingVersionActive = $routingVersionActive;
        return $this;
    }
    /**
     * Get routingVersionImported value
     * @return string|null
     */
    public function getRoutingVersionImported()
    {
        return $this->routingVersionImported;
    }
    /**
     * Set routingVersionImported value
     * @param string $routingVersionImported
     * @return \StructType\RoutingVersion
     */
    public function setRoutingVersionImported($routingVersionImported = null)
    {
        // validation for constraint: string
        if (!is_null($routingVersionImported) && !is_string($routingVersionImported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingVersionImported)), __LINE__);
        }
        $this->routingVersionImported = $routingVersionImported;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoutingVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
