<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseAddress StructType
 * @subpackage Structs
 */
class ResponseAddress extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The addressLine1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine1;
    /**
     * The addressLine2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine2;
    /**
     * The addressLine3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine3;
    /**
     * The addressLine4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine4;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * Constructor method for ResponseAddress
     * @uses ResponseAddress::setTitle()
     * @uses ResponseAddress::setAddressLine1()
     * @uses ResponseAddress::setAddressLine2()
     * @uses ResponseAddress::setAddressLine3()
     * @uses ResponseAddress::setAddressLine4()
     * @uses ResponseAddress::setPostcode()
     * @param string $title
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $addressLine4
     * @param string $postcode
     */
    public function __construct($title = null, $addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $addressLine4 = null, $postcode = null)
    {
        $this
            ->setTitle($title)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setAddressLine4($addressLine4)
            ->setPostcode($postcode);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ResponseAddress
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get addressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->addressLine1;
    }
    /**
     * Set addressLine1 value
     * @param string $addressLine1
     * @return \StructType\ResponseAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->addressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get addressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->addressLine2;
    }
    /**
     * Set addressLine2 value
     * @param string $addressLine2
     * @return \StructType\ResponseAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->addressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get addressLine3 value
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->addressLine3;
    }
    /**
     * Set addressLine3 value
     * @param string $addressLine3
     * @return \StructType\ResponseAddress
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine3)), __LINE__);
        }
        $this->addressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get addressLine4 value
     * @return string|null
     */
    public function getAddressLine4()
    {
        return $this->addressLine4;
    }
    /**
     * Set addressLine4 value
     * @param string $addressLine4
     * @return \StructType\ResponseAddress
     */
    public function setAddressLine4($addressLine4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine4) && !is_string($addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine4)), __LINE__);
        }
        $this->addressLine4 = $addressLine4;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\ResponseAddress
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
