<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for processC2CDelivery StructType
 * Meta informations extracted from the WSDL
 * - type: tns:processC2CDelivery
 * @subpackage Structs
 */
class ProcessC2CDelivery extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userType;
    /**
     * The sourceSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceSystem;
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\C2COrder
     */
    public $order;
    /**
     * The outputCriteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputCriteria
     */
    public $outputCriteria;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The oOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\C2COrder
     */
    public $oOrder;
    /**
     * Constructor method for processC2CDelivery
     * @uses ProcessC2CDelivery::setUsername()
     * @uses ProcessC2CDelivery::setUserType()
     * @uses ProcessC2CDelivery::setSourceSystem()
     * @uses ProcessC2CDelivery::setOrder()
     * @uses ProcessC2CDelivery::setOutputCriteria()
     * @uses ProcessC2CDelivery::setPassword()
     * @uses ProcessC2CDelivery::setOOrder()
     * @param string $username
     * @param string $userType
     * @param string $sourceSystem
     * @param \StructType\C2COrder $order
     * @param \StructType\OutputCriteria $outputCriteria
     * @param string $password
     * @param \StructType\C2COrder $oOrder
     */
    public function __construct($username = null, $userType = null, $sourceSystem = null, \StructType\C2COrder $order = null, \StructType\OutputCriteria $outputCriteria = null, $password = null, \StructType\C2COrder $oOrder = null)
    {
        $this
            ->setUsername($username)
            ->setUserType($userType)
            ->setSourceSystem($sourceSystem)
            ->setOrder($order)
            ->setOutputCriteria($outputCriteria)
            ->setPassword($password)
            ->setOOrder($oOrder);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ProcessC2CDelivery
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get userType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->userType;
    }
    /**
     * Set userType value
     * @param string $userType
     * @return \StructType\ProcessC2CDelivery
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userType)), __LINE__);
        }
        $this->userType = $userType;
        return $this;
    }
    /**
     * Get sourceSystem value
     * @return string|null
     */
    public function getSourceSystem()
    {
        return $this->sourceSystem;
    }
    /**
     * Set sourceSystem value
     * @param string $sourceSystem
     * @return \StructType\ProcessC2CDelivery
     */
    public function setSourceSystem($sourceSystem = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSystem) && !is_string($sourceSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceSystem)), __LINE__);
        }
        $this->sourceSystem = $sourceSystem;
        return $this;
    }
    /**
     * Get order value
     * @return \StructType\C2COrder|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param \StructType\C2COrder $order
     * @return \StructType\ProcessC2CDelivery
     */
    public function setOrder(\StructType\C2COrder $order = null)
    {
        $this->order = $order;
        return $this;
    }
    /**
     * Get outputCriteria value
     * @return \StructType\OutputCriteria|null
     */
    public function getOutputCriteria()
    {
        return $this->outputCriteria;
    }
    /**
     * Set outputCriteria value
     * @param \StructType\OutputCriteria $outputCriteria
     * @return \StructType\ProcessC2CDelivery
     */
    public function setOutputCriteria(\StructType\OutputCriteria $outputCriteria = null)
    {
        $this->outputCriteria = $outputCriteria;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\ProcessC2CDelivery
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get oOrder value
     * @return \StructType\C2COrder|null
     */
    public function getOOrder()
    {
        return $this->oOrder;
    }
    /**
     * Set oOrder value
     * @param \StructType\C2COrder $oOrder
     * @return \StructType\ProcessC2CDelivery
     */
    public function setOOrder(\StructType\C2COrder $oOrder = null)
    {
        $this->oOrder = $oOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessC2CDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
