<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for processC2BReturns StructType
 * Meta informations extracted from the WSDL
 * - type: tns:processC2BReturns
 * @subpackage Structs
 */
class ProcessC2BReturns extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The returnsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\C2BReturns[]
     */
    public $returnsList;
    /**
     * The outputCriteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputCriteria
     */
    public $outputCriteria;
    /**
     * Constructor method for processC2BReturns
     * @uses ProcessC2BReturns::setUsername()
     * @uses ProcessC2BReturns::setPassword()
     * @uses ProcessC2BReturns::setReturnsList()
     * @uses ProcessC2BReturns::setOutputCriteria()
     * @param string $username
     * @param string $password
     * @param \StructType\C2BReturns[] $returnsList
     * @param \StructType\OutputCriteria $outputCriteria
     */
    public function __construct($username = null, $password = null, array $returnsList = array(), \StructType\OutputCriteria $outputCriteria = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setReturnsList($returnsList)
            ->setOutputCriteria($outputCriteria);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ProcessC2BReturns
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\ProcessC2BReturns
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get returnsList value
     * @return \StructType\C2BReturns[]|null
     */
    public function getReturnsList()
    {
        return $this->returnsList;
    }
    /**
     * Set returnsList value
     * @throws \InvalidArgumentException
     * @param \StructType\C2BReturns[] $returnsList
     * @return \StructType\ProcessC2BReturns
     */
    public function setReturnsList(array $returnsList = array())
    {
        foreach ($returnsList as $processC2BReturnsReturnsListItem) {
            // validation for constraint: itemType
            if (!$processC2BReturnsReturnsListItem instanceof \StructType\C2BReturns) {
                throw new \InvalidArgumentException(sprintf('The returnsList property can only contain items of \StructType\C2BReturns, "%s" given', is_object($processC2BReturnsReturnsListItem) ? get_class($processC2BReturnsReturnsListItem) : gettype($processC2BReturnsReturnsListItem)), __LINE__);
            }
        }
        $this->returnsList = $returnsList;
        return $this;
    }
    /**
     * Add item to returnsList value
     * @throws \InvalidArgumentException
     * @param \StructType\C2BReturns $item
     * @return \StructType\ProcessC2BReturns
     */
    public function addToReturnsList(\StructType\C2BReturns $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\C2BReturns) {
            throw new \InvalidArgumentException(sprintf('The returnsList property can only contain items of \StructType\C2BReturns, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->returnsList[] = $item;
        return $this;
    }
    /**
     * Get outputCriteria value
     * @return \StructType\OutputCriteria|null
     */
    public function getOutputCriteria()
    {
        return $this->outputCriteria;
    }
    /**
     * Set outputCriteria value
     * @param \StructType\OutputCriteria $outputCriteria
     * @return \StructType\ProcessC2BReturns
     */
    public function setOutputCriteria(\StructType\OutputCriteria $outputCriteria = null)
    {
        $this->outputCriteria = $outputCriteria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessC2BReturns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
