<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for processC2BReturn StructType
 * Meta informations extracted from the WSDL
 * - type: tns:processC2BReturn
 * @subpackage Structs
 */
class ProcessC2BReturn extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userType;
    /**
     * The sourceSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceSystem;
    /**
     * The returnsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\C2BReturns[]
     */
    public $returnsList;
    /**
     * The outputCriteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputCriteria
     */
    public $outputCriteria;
    /**
     * Constructor method for processC2BReturn
     * @uses ProcessC2BReturn::setUsername()
     * @uses ProcessC2BReturn::setUserType()
     * @uses ProcessC2BReturn::setSourceSystem()
     * @uses ProcessC2BReturn::setReturnsList()
     * @uses ProcessC2BReturn::setOutputCriteria()
     * @param string $username
     * @param string $userType
     * @param string $sourceSystem
     * @param \StructType\C2BReturns[] $returnsList
     * @param \StructType\OutputCriteria $outputCriteria
     */
    public function __construct($username = null, $userType = null, $sourceSystem = null, array $returnsList = array(), \StructType\OutputCriteria $outputCriteria = null)
    {
        $this
            ->setUsername($username)
            ->setUserType($userType)
            ->setSourceSystem($sourceSystem)
            ->setReturnsList($returnsList)
            ->setOutputCriteria($outputCriteria);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ProcessC2BReturn
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get userType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->userType;
    }
    /**
     * Set userType value
     * @param string $userType
     * @return \StructType\ProcessC2BReturn
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userType)), __LINE__);
        }
        $this->userType = $userType;
        return $this;
    }
    /**
     * Get sourceSystem value
     * @return string|null
     */
    public function getSourceSystem()
    {
        return $this->sourceSystem;
    }
    /**
     * Set sourceSystem value
     * @param string $sourceSystem
     * @return \StructType\ProcessC2BReturn
     */
    public function setSourceSystem($sourceSystem = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSystem) && !is_string($sourceSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceSystem)), __LINE__);
        }
        $this->sourceSystem = $sourceSystem;
        return $this;
    }
    /**
     * Get returnsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\C2BReturns[]|null
     */
    public function getReturnsList()
    {
        return isset($this->returnsList) ? $this->returnsList : null;
    }
    /**
     * Set returnsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\C2BReturns[] $returnsList
     * @return \StructType\ProcessC2BReturn
     */
    public function setReturnsList(array $returnsList = array())
    {
        foreach ($returnsList as $processC2BReturnReturnsListItem) {
            // validation for constraint: itemType
            if (!$processC2BReturnReturnsListItem instanceof \StructType\C2BReturns) {
                throw new \InvalidArgumentException(sprintf('The returnsList property can only contain items of \StructType\C2BReturns, "%s" given', is_object($processC2BReturnReturnsListItem) ? get_class($processC2BReturnReturnsListItem) : gettype($processC2BReturnReturnsListItem)), __LINE__);
            }
        }
        if (is_null($returnsList) || (is_array($returnsList) && empty($returnsList))) {
            unset($this->returnsList);
        } else {
            $this->returnsList = $returnsList;
        }
        return $this;
    }
    /**
     * Add item to returnsList value
     * @throws \InvalidArgumentException
     * @param \StructType\C2BReturns $item
     * @return \StructType\ProcessC2BReturn
     */
    public function addToReturnsList(\StructType\C2BReturns $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\C2BReturns) {
            throw new \InvalidArgumentException(sprintf('The returnsList property can only contain items of \StructType\C2BReturns, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->returnsList[] = $item;
        return $this;
    }
    /**
     * Get outputCriteria value
     * @return \StructType\OutputCriteria|null
     */
    public function getOutputCriteria()
    {
        return $this->outputCriteria;
    }
    /**
     * Set outputCriteria value
     * @param \StructType\OutputCriteria $outputCriteria
     * @return \StructType\ProcessC2BReturn
     */
    public function setOutputCriteria(\StructType\OutputCriteria $outputCriteria = null)
    {
        $this->outputCriteria = $outputCriteria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessC2BReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
