<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for processB2CDelivery StructType
 * Meta informations extracted from the WSDL
 * - type: tns:processB2CDelivery
 * @subpackage Structs
 */
class ProcessB2CDelivery extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userType;
    /**
     * The sourceSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceSystem;
    /**
     * The shipmentList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\B2CDelivery[]
     */
    public $shipmentList;
    /**
     * The outputCriteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputCriteria
     */
    public $outputCriteria;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for processB2CDelivery
     * @uses ProcessB2CDelivery::setUsername()
     * @uses ProcessB2CDelivery::setUserType()
     * @uses ProcessB2CDelivery::setSourceSystem()
     * @uses ProcessB2CDelivery::setShipmentList()
     * @uses ProcessB2CDelivery::setOutputCriteria()
     * @uses ProcessB2CDelivery::setPassword()
     * @param string $username
     * @param string $userType
     * @param string $sourceSystem
     * @param \StructType\B2CDelivery[] $shipmentList
     * @param \StructType\OutputCriteria $outputCriteria
     * @param string $password
     */
    public function __construct($username = null, $userType = null, $sourceSystem = null, array $shipmentList = array(), \StructType\OutputCriteria $outputCriteria = null, $password = null)
    {
        $this
            ->setUsername($username)
            ->setUserType($userType)
            ->setSourceSystem($sourceSystem)
            ->setShipmentList($shipmentList)
            ->setOutputCriteria($outputCriteria)
            ->setPassword($password);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ProcessB2CDelivery
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get userType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->userType;
    }
    /**
     * Set userType value
     * @param string $userType
     * @return \StructType\ProcessB2CDelivery
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userType)), __LINE__);
        }
        $this->userType = $userType;
        return $this;
    }
    /**
     * Get sourceSystem value
     * @return string|null
     */
    public function getSourceSystem()
    {
        return $this->sourceSystem;
    }
    /**
     * Set sourceSystem value
     * @param string $sourceSystem
     * @return \StructType\ProcessB2CDelivery
     */
    public function setSourceSystem($sourceSystem = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSystem) && !is_string($sourceSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceSystem)), __LINE__);
        }
        $this->sourceSystem = $sourceSystem;
        return $this;
    }
    /**
     * Get shipmentList value
     * @return \StructType\B2CDelivery[]|null
     */
    public function getShipmentList()
    {
        return $this->shipmentList;
    }
    /**
     * Set shipmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\B2CDelivery[] $shipmentList
     * @return \StructType\ProcessB2CDelivery
     */
    public function setShipmentList(array $shipmentList = array())
    {
        foreach ($shipmentList as $processB2CDeliveryShipmentListItem) {
            // validation for constraint: itemType
            if (!$processB2CDeliveryShipmentListItem instanceof \StructType\B2CDelivery) {
                throw new \InvalidArgumentException(sprintf('The shipmentList property can only contain items of \StructType\B2CDelivery, "%s" given', is_object($processB2CDeliveryShipmentListItem) ? get_class($processB2CDeliveryShipmentListItem) : gettype($processB2CDeliveryShipmentListItem)), __LINE__);
            }
        }
        $this->shipmentList = $shipmentList;
        return $this;
    }
    /**
     * Add item to shipmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\B2CDelivery $item
     * @return \StructType\ProcessB2CDelivery
     */
    public function addToShipmentList(\StructType\B2CDelivery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\B2CDelivery) {
            throw new \InvalidArgumentException(sprintf('The shipmentList property can only contain items of \StructType\B2CDelivery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shipmentList[] = $item;
        return $this;
    }
    /**
     * Get outputCriteria value
     * @return \StructType\OutputCriteria|null
     */
    public function getOutputCriteria()
    {
        return $this->outputCriteria;
    }
    /**
     * Set outputCriteria value
     * @param \StructType\OutputCriteria $outputCriteria
     * @return \StructType\ProcessB2CDelivery
     */
    public function setOutputCriteria(\StructType\OutputCriteria $outputCriteria = null)
    {
        $this->outputCriteria = $outputCriteria;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\ProcessB2CDelivery
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessB2CDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
