<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for processB2CCollection StructType
 * Meta informations extracted from the WSDL
 * - type: tns:processB2CCollection
 * @subpackage Structs
 */
class ProcessB2CCollection extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userType;
    /**
     * The sourceSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceSystem;
    /**
     * The collectionList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\B2CCollection[]
     */
    public $collectionList;
    /**
     * The outputCriteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputCriteria
     */
    public $outputCriteria;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The returnsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\B2CCollection[]
     */
    public $returnsList;
    /**
     * Constructor method for processB2CCollection
     * @uses ProcessB2CCollection::setUsername()
     * @uses ProcessB2CCollection::setUserType()
     * @uses ProcessB2CCollection::setSourceSystem()
     * @uses ProcessB2CCollection::setCollectionList()
     * @uses ProcessB2CCollection::setOutputCriteria()
     * @uses ProcessB2CCollection::setPassword()
     * @uses ProcessB2CCollection::setReturnsList()
     * @param string $username
     * @param string $userType
     * @param string $sourceSystem
     * @param \StructType\B2CCollection[] $collectionList
     * @param \StructType\OutputCriteria $outputCriteria
     * @param string $password
     * @param \StructType\B2CCollection[] $returnsList
     */
    public function __construct($username = null, $userType = null, $sourceSystem = null, array $collectionList = array(), \StructType\OutputCriteria $outputCriteria = null, $password = null, array $returnsList = array())
    {
        $this
            ->setUsername($username)
            ->setUserType($userType)
            ->setSourceSystem($sourceSystem)
            ->setCollectionList($collectionList)
            ->setOutputCriteria($outputCriteria)
            ->setPassword($password)
            ->setReturnsList($returnsList);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ProcessB2CCollection
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get userType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->userType;
    }
    /**
     * Set userType value
     * @param string $userType
     * @return \StructType\ProcessB2CCollection
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userType)), __LINE__);
        }
        $this->userType = $userType;
        return $this;
    }
    /**
     * Get sourceSystem value
     * @return string|null
     */
    public function getSourceSystem()
    {
        return $this->sourceSystem;
    }
    /**
     * Set sourceSystem value
     * @param string $sourceSystem
     * @return \StructType\ProcessB2CCollection
     */
    public function setSourceSystem($sourceSystem = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSystem) && !is_string($sourceSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceSystem)), __LINE__);
        }
        $this->sourceSystem = $sourceSystem;
        return $this;
    }
    /**
     * Get collectionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\B2CCollection[]|null
     */
    public function getCollectionList()
    {
        return isset($this->collectionList) ? $this->collectionList : null;
    }
    /**
     * Set collectionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\B2CCollection[] $collectionList
     * @return \StructType\ProcessB2CCollection
     */
    public function setCollectionList(array $collectionList = array())
    {
        foreach ($collectionList as $processB2CCollectionCollectionListItem) {
            // validation for constraint: itemType
            if (!$processB2CCollectionCollectionListItem instanceof \StructType\B2CCollection) {
                throw new \InvalidArgumentException(sprintf('The collectionList property can only contain items of \StructType\B2CCollection, "%s" given', is_object($processB2CCollectionCollectionListItem) ? get_class($processB2CCollectionCollectionListItem) : gettype($processB2CCollectionCollectionListItem)), __LINE__);
            }
        }
        if (is_null($collectionList) || (is_array($collectionList) && empty($collectionList))) {
            unset($this->collectionList);
        } else {
            $this->collectionList = $collectionList;
        }
        return $this;
    }
    /**
     * Add item to collectionList value
     * @throws \InvalidArgumentException
     * @param \StructType\B2CCollection $item
     * @return \StructType\ProcessB2CCollection
     */
    public function addToCollectionList(\StructType\B2CCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\B2CCollection) {
            throw new \InvalidArgumentException(sprintf('The collectionList property can only contain items of \StructType\B2CCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->collectionList[] = $item;
        return $this;
    }
    /**
     * Get outputCriteria value
     * @return \StructType\OutputCriteria|null
     */
    public function getOutputCriteria()
    {
        return $this->outputCriteria;
    }
    /**
     * Set outputCriteria value
     * @param \StructType\OutputCriteria $outputCriteria
     * @return \StructType\ProcessB2CCollection
     */
    public function setOutputCriteria(\StructType\OutputCriteria $outputCriteria = null)
    {
        $this->outputCriteria = $outputCriteria;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\ProcessB2CCollection
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get returnsList value
     * @return \StructType\B2CCollection[]|null
     */
    public function getReturnsList()
    {
        return $this->returnsList;
    }
    /**
     * Set returnsList value
     * @throws \InvalidArgumentException
     * @param \StructType\B2CCollection[] $returnsList
     * @return \StructType\ProcessB2CCollection
     */
    public function setReturnsList(array $returnsList = array())
    {
        foreach ($returnsList as $processB2CCollectionReturnsListItem) {
            // validation for constraint: itemType
            if (!$processB2CCollectionReturnsListItem instanceof \StructType\B2CCollection) {
                throw new \InvalidArgumentException(sprintf('The returnsList property can only contain items of \StructType\B2CCollection, "%s" given', is_object($processB2CCollectionReturnsListItem) ? get_class($processB2CCollectionReturnsListItem) : gettype($processB2CCollectionReturnsListItem)), __LINE__);
            }
        }
        $this->returnsList = $returnsList;
        return $this;
    }
    /**
     * Add item to returnsList value
     * @throws \InvalidArgumentException
     * @param \StructType\B2CCollection $item
     * @return \StructType\ProcessB2CCollection
     */
    public function addToReturnsList(\StructType\B2CCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\B2CCollection) {
            throw new \InvalidArgumentException(sprintf('The returnsList property can only contain items of \StructType\B2CCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->returnsList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessB2CCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
