<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The lastCancellationTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastCancellationTimestamp;
    /**
     * The onlinePayment
     * @var bool
     */
    public $onlinePayment;
    /**
     * The paymentAmount
     * @var int
     */
    public $paymentAmount;
    /**
     * The paymentCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentCurrency;
    /**
     * The paymentTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentTimestamp;
    /**
     * Constructor method for payment
     * @uses Payment::setLastCancellationTimestamp()
     * @uses Payment::setOnlinePayment()
     * @uses Payment::setPaymentAmount()
     * @uses Payment::setPaymentCurrency()
     * @uses Payment::setPaymentTimestamp()
     * @param string $lastCancellationTimestamp
     * @param bool $onlinePayment
     * @param int $paymentAmount
     * @param string $paymentCurrency
     * @param string $paymentTimestamp
     */
    public function __construct($lastCancellationTimestamp = null, $onlinePayment = null, $paymentAmount = null, $paymentCurrency = null, $paymentTimestamp = null)
    {
        $this
            ->setLastCancellationTimestamp($lastCancellationTimestamp)
            ->setOnlinePayment($onlinePayment)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentCurrency($paymentCurrency)
            ->setPaymentTimestamp($paymentTimestamp);
    }
    /**
     * Get lastCancellationTimestamp value
     * @return string|null
     */
    public function getLastCancellationTimestamp()
    {
        return $this->lastCancellationTimestamp;
    }
    /**
     * Set lastCancellationTimestamp value
     * @param string $lastCancellationTimestamp
     * @return \StructType\Payment
     */
    public function setLastCancellationTimestamp($lastCancellationTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($lastCancellationTimestamp) && !is_string($lastCancellationTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCancellationTimestamp)), __LINE__);
        }
        $this->lastCancellationTimestamp = $lastCancellationTimestamp;
        return $this;
    }
    /**
     * Get onlinePayment value
     * @return bool|null
     */
    public function getOnlinePayment()
    {
        return $this->onlinePayment;
    }
    /**
     * Set onlinePayment value
     * @param bool $onlinePayment
     * @return \StructType\Payment
     */
    public function setOnlinePayment($onlinePayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlinePayment) && !is_bool($onlinePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlinePayment)), __LINE__);
        }
        $this->onlinePayment = $onlinePayment;
        return $this;
    }
    /**
     * Get paymentAmount value
     * @return int|null
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }
    /**
     * Set paymentAmount value
     * @param int $paymentAmount
     * @return \StructType\Payment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAmount) && !is_numeric($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->paymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get paymentCurrency value
     * @return string|null
     */
    public function getPaymentCurrency()
    {
        return $this->paymentCurrency;
    }
    /**
     * Set paymentCurrency value
     * @param string $paymentCurrency
     * @return \StructType\Payment
     */
    public function setPaymentCurrency($paymentCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCurrency) && !is_string($paymentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentCurrency)), __LINE__);
        }
        $this->paymentCurrency = $paymentCurrency;
        return $this;
    }
    /**
     * Get paymentTimestamp value
     * @return string|null
     */
    public function getPaymentTimestamp()
    {
        return $this->paymentTimestamp;
    }
    /**
     * Set paymentTimestamp value
     * @param string $paymentTimestamp
     * @return \StructType\Payment
     */
    public function setPaymentTimestamp($paymentTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimestamp) && !is_string($paymentTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTimestamp)), __LINE__);
        }
        $this->paymentTimestamp = $paymentTimestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
