<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for outputCriteria StructType
 * @subpackage Structs
 */
class OutputCriteria extends AbstractStructBase
{
    /**
     * The labelOutputFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelOutputFormat;
    /**
     * The transmissionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transmissionCode;
    /**
     * Constructor method for outputCriteria
     * @uses OutputCriteria::setLabelOutputFormat()
     * @uses OutputCriteria::setTransmissionCode()
     * @param string $labelOutputFormat
     * @param string $transmissionCode
     */
    public function __construct($labelOutputFormat = null, $transmissionCode = null)
    {
        $this
            ->setLabelOutputFormat($labelOutputFormat)
            ->setTransmissionCode($transmissionCode);
    }
    /**
     * Get labelOutputFormat value
     * @return string|null
     */
    public function getLabelOutputFormat()
    {
        return $this->labelOutputFormat;
    }
    /**
     * Set labelOutputFormat value
     * @param string $labelOutputFormat
     * @return \StructType\OutputCriteria
     */
    public function setLabelOutputFormat($labelOutputFormat = null)
    {
        // validation for constraint: string
        if (!is_null($labelOutputFormat) && !is_string($labelOutputFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelOutputFormat)), __LINE__);
        }
        $this->labelOutputFormat = $labelOutputFormat;
        return $this;
    }
    /**
     * Get transmissionCode value
     * @return string|null
     */
    public function getTransmissionCode()
    {
        return $this->transmissionCode;
    }
    /**
     * Set transmissionCode value
     * @param string $transmissionCode
     * @return \StructType\OutputCriteria
     */
    public function setTransmissionCode($transmissionCode = null)
    {
        // validation for constraint: string
        if (!is_null($transmissionCode) && !is_string($transmissionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmissionCode)), __LINE__);
        }
        $this->transmissionCode = $transmissionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutputCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
