<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Label StructType
 * @subpackage Structs
 */
class Label extends AbstractStructBase
{
    /**
     * The clientAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClientAddress
     */
    public $clientAddress;
    /**
     * The senderAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SenderAddress
     */
    public $senderAddress;
    /**
     * The destinationAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DestinationAddress
     */
    public $destinationAddress;
    /**
     * The carrier1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Carrier
     */
    public $carrier1;
    /**
     * The carrier2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Carrier
     */
    public $carrier2;
    /**
     * The serviceDescriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceDescription[]
     */
    public $serviceDescriptions;
    /**
     * The entities
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Entity[]
     */
    public $entities;
    /**
     * The labelType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelType;
    /**
     * The labelID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelID;
    /**
     * The labelImages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $labelImages;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErosUserError[]
     */
    public $errors;
    /**
     * The warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErosUserWarning[]
     */
    public $warnings;
    /**
     * The process
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $process;
    /**
     * The clientLogoRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clientLogoRef;
    /**
     * The customerReference1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerReference1;
    /**
     * The customerReference2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerReference2;
    /**
     * Constructor method for Label
     * @uses Label::setClientAddress()
     * @uses Label::setSenderAddress()
     * @uses Label::setDestinationAddress()
     * @uses Label::setCarrier1()
     * @uses Label::setCarrier2()
     * @uses Label::setServiceDescriptions()
     * @uses Label::setEntities()
     * @uses Label::setLabelType()
     * @uses Label::setLabelID()
     * @uses Label::setLabelImages()
     * @uses Label::setErrors()
     * @uses Label::setWarnings()
     * @uses Label::setProcess()
     * @uses Label::setClientLogoRef()
     * @uses Label::setCustomerReference1()
     * @uses Label::setCustomerReference2()
     * @param \StructType\ClientAddress $clientAddress
     * @param \StructType\SenderAddress $senderAddress
     * @param \StructType\DestinationAddress $destinationAddress
     * @param \StructType\Carrier $carrier1
     * @param \StructType\Carrier $carrier2
     * @param \StructType\ServiceDescription[] $serviceDescriptions
     * @param \StructType\Entity[] $entities
     * @param string $labelType
     * @param string $labelID
     * @param string[] $labelImages
     * @param \StructType\ErosUserError[] $errors
     * @param \StructType\ErosUserWarning[] $warnings
     * @param string $process
     * @param string $clientLogoRef
     * @param string $customerReference1
     * @param string $customerReference2
     */
    public function __construct(\StructType\ClientAddress $clientAddress = null, \StructType\SenderAddress $senderAddress = null, \StructType\DestinationAddress $destinationAddress = null, \StructType\Carrier $carrier1 = null, \StructType\Carrier $carrier2 = null, array $serviceDescriptions = array(), array $entities = array(), $labelType = null, $labelID = null, array $labelImages = array(), array $errors = array(), array $warnings = array(), $process = null, $clientLogoRef = null, $customerReference1 = null, $customerReference2 = null)
    {
        $this
            ->setClientAddress($clientAddress)
            ->setSenderAddress($senderAddress)
            ->setDestinationAddress($destinationAddress)
            ->setCarrier1($carrier1)
            ->setCarrier2($carrier2)
            ->setServiceDescriptions($serviceDescriptions)
            ->setEntities($entities)
            ->setLabelType($labelType)
            ->setLabelID($labelID)
            ->setLabelImages($labelImages)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setProcess($process)
            ->setClientLogoRef($clientLogoRef)
            ->setCustomerReference1($customerReference1)
            ->setCustomerReference2($customerReference2);
    }
    /**
     * Get clientAddress value
     * @return \StructType\ClientAddress|null
     */
    public function getClientAddress()
    {
        return $this->clientAddress;
    }
    /**
     * Set clientAddress value
     * @param \StructType\ClientAddress $clientAddress
     * @return \StructType\Label
     */
    public function setClientAddress(\StructType\ClientAddress $clientAddress = null)
    {
        $this->clientAddress = $clientAddress;
        return $this;
    }
    /**
     * Get senderAddress value
     * @return \StructType\SenderAddress|null
     */
    public function getSenderAddress()
    {
        return $this->senderAddress;
    }
    /**
     * Set senderAddress value
     * @param \StructType\SenderAddress $senderAddress
     * @return \StructType\Label
     */
    public function setSenderAddress(\StructType\SenderAddress $senderAddress = null)
    {
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return \StructType\DestinationAddress|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param \StructType\DestinationAddress $destinationAddress
     * @return \StructType\Label
     */
    public function setDestinationAddress(\StructType\DestinationAddress $destinationAddress = null)
    {
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get carrier1 value
     * @return \StructType\Carrier|null
     */
    public function getCarrier1()
    {
        return $this->carrier1;
    }
    /**
     * Set carrier1 value
     * @param \StructType\Carrier $carrier1
     * @return \StructType\Label
     */
    public function setCarrier1(\StructType\Carrier $carrier1 = null)
    {
        $this->carrier1 = $carrier1;
        return $this;
    }
    /**
     * Get carrier2 value
     * @return \StructType\Carrier|null
     */
    public function getCarrier2()
    {
        return $this->carrier2;
    }
    /**
     * Set carrier2 value
     * @param \StructType\Carrier $carrier2
     * @return \StructType\Label
     */
    public function setCarrier2(\StructType\Carrier $carrier2 = null)
    {
        $this->carrier2 = $carrier2;
        return $this;
    }
    /**
     * Get serviceDescriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceDescription[]|null
     */
    public function getServiceDescriptions()
    {
        return isset($this->serviceDescriptions) ? $this->serviceDescriptions : null;
    }
    /**
     * Set serviceDescriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDescription[] $serviceDescriptions
     * @return \StructType\Label
     */
    public function setServiceDescriptions(array $serviceDescriptions = array())
    {
        foreach ($serviceDescriptions as $labelServiceDescriptionsItem) {
            // validation for constraint: itemType
            if (!$labelServiceDescriptionsItem instanceof \StructType\ServiceDescription) {
                throw new \InvalidArgumentException(sprintf('The serviceDescriptions property can only contain items of \StructType\ServiceDescription, "%s" given', is_object($labelServiceDescriptionsItem) ? get_class($labelServiceDescriptionsItem) : gettype($labelServiceDescriptionsItem)), __LINE__);
            }
        }
        if (is_null($serviceDescriptions) || (is_array($serviceDescriptions) && empty($serviceDescriptions))) {
            unset($this->serviceDescriptions);
        } else {
            $this->serviceDescriptions = $serviceDescriptions;
        }
        return $this;
    }
    /**
     * Add item to serviceDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDescription $item
     * @return \StructType\Label
     */
    public function addToServiceDescriptions(\StructType\ServiceDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceDescription) {
            throw new \InvalidArgumentException(sprintf('The serviceDescriptions property can only contain items of \StructType\ServiceDescription, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceDescriptions[] = $item;
        return $this;
    }
    /**
     * Get entities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Entity[]|null
     */
    public function getEntities()
    {
        return isset($this->entities) ? $this->entities : null;
    }
    /**
     * Set entities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Entity[] $entities
     * @return \StructType\Label
     */
    public function setEntities(array $entities = array())
    {
        foreach ($entities as $labelEntitiesItem) {
            // validation for constraint: itemType
            if (!$labelEntitiesItem instanceof \StructType\Entity) {
                throw new \InvalidArgumentException(sprintf('The entities property can only contain items of \StructType\Entity, "%s" given', is_object($labelEntitiesItem) ? get_class($labelEntitiesItem) : gettype($labelEntitiesItem)), __LINE__);
            }
        }
        if (is_null($entities) || (is_array($entities) && empty($entities))) {
            unset($this->entities);
        } else {
            $this->entities = $entities;
        }
        return $this;
    }
    /**
     * Add item to entities value
     * @throws \InvalidArgumentException
     * @param \StructType\Entity $item
     * @return \StructType\Label
     */
    public function addToEntities(\StructType\Entity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Entity) {
            throw new \InvalidArgumentException(sprintf('The entities property can only contain items of \StructType\Entity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entities[] = $item;
        return $this;
    }
    /**
     * Get labelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->labelType;
    }
    /**
     * Set labelType value
     * @param string $labelType
     * @return \StructType\Label
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: string
        if (!is_null($labelType) && !is_string($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelType)), __LINE__);
        }
        $this->labelType = $labelType;
        return $this;
    }
    /**
     * Get labelID value
     * @return string|null
     */
    public function getLabelID()
    {
        return $this->labelID;
    }
    /**
     * Set labelID value
     * @param string $labelID
     * @return \StructType\Label
     */
    public function setLabelID($labelID = null)
    {
        // validation for constraint: string
        if (!is_null($labelID) && !is_string($labelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelID)), __LINE__);
        }
        $this->labelID = $labelID;
        return $this;
    }
    /**
     * Get labelImages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLabelImages()
    {
        return isset($this->labelImages) ? $this->labelImages : null;
    }
    /**
     * Set labelImages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $labelImages
     * @return \StructType\Label
     */
    public function setLabelImages(array $labelImages = array())
    {
        foreach ($labelImages as $labelLabelImagesItem) {
            // validation for constraint: itemType
            if (!is_string($labelLabelImagesItem)) {
                throw new \InvalidArgumentException(sprintf('The labelImages property can only contain items of base64Binary, "%s" given', is_object($labelLabelImagesItem) ? get_class($labelLabelImagesItem) : gettype($labelLabelImagesItem)), __LINE__);
            }
        }
        if (is_null($labelImages) || (is_array($labelImages) && empty($labelImages))) {
            unset($this->labelImages);
        } else {
            $this->labelImages = $labelImages;
        }
        return $this;
    }
    /**
     * Add item to labelImages value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Label
     */
    public function addToLabelImages($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The labelImages property can only contain items of base64Binary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->labelImages[] = $item;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErosUserError[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserError[] $errors
     * @return \StructType\Label
     */
    public function setErrors(array $errors = array())
    {
        foreach ($errors as $labelErrorsItem) {
            // validation for constraint: itemType
            if (!$labelErrorsItem instanceof \StructType\ErosUserError) {
                throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \StructType\ErosUserError, "%s" given', is_object($labelErrorsItem) ? get_class($labelErrorsItem) : gettype($labelErrorsItem)), __LINE__);
            }
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserError $item
     * @return \StructType\Label
     */
    public function addToErrors(\StructType\ErosUserError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErosUserError) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \StructType\ErosUserError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErosUserWarning[]|null
     */
    public function getWarnings()
    {
        return isset($this->warnings) ? $this->warnings : null;
    }
    /**
     * Set warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserWarning[] $warnings
     * @return \StructType\Label
     */
    public function setWarnings(array $warnings = array())
    {
        foreach ($warnings as $labelWarningsItem) {
            // validation for constraint: itemType
            if (!$labelWarningsItem instanceof \StructType\ErosUserWarning) {
                throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of \StructType\ErosUserWarning, "%s" given', is_object($labelWarningsItem) ? get_class($labelWarningsItem) : gettype($labelWarningsItem)), __LINE__);
            }
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->warnings);
        } else {
            $this->warnings = $warnings;
        }
        return $this;
    }
    /**
     * Add item to warnings value
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserWarning $item
     * @return \StructType\Label
     */
    public function addToWarnings(\StructType\ErosUserWarning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErosUserWarning) {
            throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of \StructType\ErosUserWarning, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->warnings[] = $item;
        return $this;
    }
    /**
     * Get process value
     * @return string|null
     */
    public function getProcess()
    {
        return $this->process;
    }
    /**
     * Set process value
     * @param string $process
     * @return \StructType\Label
     */
    public function setProcess($process = null)
    {
        // validation for constraint: string
        if (!is_null($process) && !is_string($process)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($process)), __LINE__);
        }
        $this->process = $process;
        return $this;
    }
    /**
     * Get clientLogoRef value
     * @return string|null
     */
    public function getClientLogoRef()
    {
        return $this->clientLogoRef;
    }
    /**
     * Set clientLogoRef value
     * @param string $clientLogoRef
     * @return \StructType\Label
     */
    public function setClientLogoRef($clientLogoRef = null)
    {
        // validation for constraint: string
        if (!is_null($clientLogoRef) && !is_string($clientLogoRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientLogoRef)), __LINE__);
        }
        $this->clientLogoRef = $clientLogoRef;
        return $this;
    }
    /**
     * Get customerReference1 value
     * @return string|null
     */
    public function getCustomerReference1()
    {
        return $this->customerReference1;
    }
    /**
     * Set customerReference1 value
     * @param string $customerReference1
     * @return \StructType\Label
     */
    public function setCustomerReference1($customerReference1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference1) && !is_string($customerReference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference1)), __LINE__);
        }
        $this->customerReference1 = $customerReference1;
        return $this;
    }
    /**
     * Get customerReference2 value
     * @return string|null
     */
    public function getCustomerReference2()
    {
        return $this->customerReference2;
    }
    /**
     * Set customerReference2 value
     * @param string $customerReference2
     * @return \StructType\Label
     */
    public function setCustomerReference2($customerReference2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference2) && !is_string($customerReference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference2)), __LINE__);
        }
        $this->customerReference2 = $customerReference2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Label
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
