<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentService StructType
 * @subpackage Structs
 */
class IdentService extends AbstractStructBase
{
    /**
     * The idCardNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idCardNo;
    /**
     * The idCardType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idCardType;
    /**
     * The ageValidation
     * @var int
     */
    public $ageValidation;
    /**
     * The dateOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateOfBirth;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PIN;
    /**
     * The module
     * @var string
     */
    public $module;
    /**
     * Constructor method for IdentService
     * @uses IdentService::setIdCardNo()
     * @uses IdentService::setIdCardType()
     * @uses IdentService::setAgeValidation()
     * @uses IdentService::setDateOfBirth()
     * @uses IdentService::setPIN()
     * @uses IdentService::setModule()
     * @param string $idCardNo
     * @param string $idCardType
     * @param int $ageValidation
     * @param string $dateOfBirth
     * @param string $pIN
     * @param string $module
     */
    public function __construct($idCardNo = null, $idCardType = null, $ageValidation = null, $dateOfBirth = null, $pIN = null, $module = null)
    {
        $this
            ->setIdCardNo($idCardNo)
            ->setIdCardType($idCardType)
            ->setAgeValidation($ageValidation)
            ->setDateOfBirth($dateOfBirth)
            ->setPIN($pIN)
            ->setModule($module);
    }
    /**
     * Get idCardNo value
     * @return string|null
     */
    public function getIdCardNo()
    {
        return $this->idCardNo;
    }
    /**
     * Set idCardNo value
     * @param string $idCardNo
     * @return \StructType\IdentService
     */
    public function setIdCardNo($idCardNo = null)
    {
        // validation for constraint: string
        if (!is_null($idCardNo) && !is_string($idCardNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCardNo)), __LINE__);
        }
        $this->idCardNo = $idCardNo;
        return $this;
    }
    /**
     * Get idCardType value
     * @return string|null
     */
    public function getIdCardType()
    {
        return $this->idCardType;
    }
    /**
     * Set idCardType value
     * @param string $idCardType
     * @return \StructType\IdentService
     */
    public function setIdCardType($idCardType = null)
    {
        // validation for constraint: string
        if (!is_null($idCardType) && !is_string($idCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCardType)), __LINE__);
        }
        $this->idCardType = $idCardType;
        return $this;
    }
    /**
     * Get ageValidation value
     * @return int|null
     */
    public function getAgeValidation()
    {
        return $this->ageValidation;
    }
    /**
     * Set ageValidation value
     * @param int $ageValidation
     * @return \StructType\IdentService
     */
    public function setAgeValidation($ageValidation = null)
    {
        // validation for constraint: int
        if (!is_null($ageValidation) && !is_numeric($ageValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ageValidation)), __LINE__);
        }
        $this->ageValidation = $ageValidation;
        return $this;
    }
    /**
     * Get dateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->dateOfBirth;
    }
    /**
     * Set dateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\IdentService
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfBirth)), __LINE__);
        }
        $this->dateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\IdentService
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get module value
     * @return string|null
     */
    public function getModule()
    {
        return $this->module;
    }
    /**
     * Set module value
     * @param string $module
     * @return \StructType\IdentService
     */
    public function setModule($module = null)
    {
        // validation for constraint: string
        if (!is_null($module) && !is_string($module)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($module)), __LINE__);
        }
        $this->module = $module;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
