<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cashOnDelivery StructType
 * @subpackage Structs
 */
class CashOnDelivery extends AbstractStructBase
{
    /**
     * The bankTransferCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankTransferCurrency;
    /**
     * The bankTransferValue
     * @var int
     */
    public $bankTransferValue;
    /**
     * The cashCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cashCurrency;
    /**
     * The cashValue
     * @var int
     */
    public $cashValue;
    /**
     * Constructor method for cashOnDelivery
     * @uses CashOnDelivery::setBankTransferCurrency()
     * @uses CashOnDelivery::setBankTransferValue()
     * @uses CashOnDelivery::setCashCurrency()
     * @uses CashOnDelivery::setCashValue()
     * @param string $bankTransferCurrency
     * @param int $bankTransferValue
     * @param string $cashCurrency
     * @param int $cashValue
     */
    public function __construct($bankTransferCurrency = null, $bankTransferValue = null, $cashCurrency = null, $cashValue = null)
    {
        $this
            ->setBankTransferCurrency($bankTransferCurrency)
            ->setBankTransferValue($bankTransferValue)
            ->setCashCurrency($cashCurrency)
            ->setCashValue($cashValue);
    }
    /**
     * Get bankTransferCurrency value
     * @return string|null
     */
    public function getBankTransferCurrency()
    {
        return $this->bankTransferCurrency;
    }
    /**
     * Set bankTransferCurrency value
     * @param string $bankTransferCurrency
     * @return \StructType\CashOnDelivery
     */
    public function setBankTransferCurrency($bankTransferCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($bankTransferCurrency) && !is_string($bankTransferCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankTransferCurrency)), __LINE__);
        }
        $this->bankTransferCurrency = $bankTransferCurrency;
        return $this;
    }
    /**
     * Get bankTransferValue value
     * @return int|null
     */
    public function getBankTransferValue()
    {
        return $this->bankTransferValue;
    }
    /**
     * Set bankTransferValue value
     * @param int $bankTransferValue
     * @return \StructType\CashOnDelivery
     */
    public function setBankTransferValue($bankTransferValue = null)
    {
        // validation for constraint: int
        if (!is_null($bankTransferValue) && !is_numeric($bankTransferValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bankTransferValue)), __LINE__);
        }
        $this->bankTransferValue = $bankTransferValue;
        return $this;
    }
    /**
     * Get cashCurrency value
     * @return string|null
     */
    public function getCashCurrency()
    {
        return $this->cashCurrency;
    }
    /**
     * Set cashCurrency value
     * @param string $cashCurrency
     * @return \StructType\CashOnDelivery
     */
    public function setCashCurrency($cashCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cashCurrency) && !is_string($cashCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cashCurrency)), __LINE__);
        }
        $this->cashCurrency = $cashCurrency;
        return $this;
    }
    /**
     * Get cashValue value
     * @return int|null
     */
    public function getCashValue()
    {
        return $this->cashValue;
    }
    /**
     * Set cashValue value
     * @param int $cashValue
     * @return \StructType\CashOnDelivery
     */
    public function setCashValue($cashValue = null)
    {
        // validation for constraint: int
        if (!is_null($cashValue) && !is_numeric($cashValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cashValue)), __LINE__);
        }
        $this->cashValue = $cashValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CashOnDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
