<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelResponse StructType
 * @subpackage Structs
 */
class CancelResponse extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNo;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErosUserError[]
     */
    public $errors;
    /**
     * Constructor method for CancelResponse
     * @uses CancelResponse::setOrderNo()
     * @uses CancelResponse::setErrors()
     * @param string $orderNo
     * @param \StructType\ErosUserError[] $errors
     */
    public function __construct($orderNo = null, array $errors = array())
    {
        $this
            ->setOrderNo($orderNo)
            ->setErrors($errors);
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\CancelResponse
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErosUserError[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserError[] $errors
     * @return \StructType\CancelResponse
     */
    public function setErrors(array $errors = array())
    {
        foreach ($errors as $cancelResponseErrorsItem) {
            // validation for constraint: itemType
            if (!$cancelResponseErrorsItem instanceof \StructType\ErosUserError) {
                throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \StructType\ErosUserError, "%s" given', is_object($cancelResponseErrorsItem) ? get_class($cancelResponseErrorsItem) : gettype($cancelResponseErrorsItem)), __LINE__);
            }
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserError $item
     * @return \StructType\CancelResponse
     */
    public function addToErrors(\StructType\ErosUserError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErosUserError) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \StructType\ErosUserError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
