<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for c2CShipment StructType
 * @subpackage Structs
 */
class C2CShipment extends C2CDelivery
{
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Payment
     */
    public $payment;
    /**
     * The priceCatLongName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceCatLongName;
    /**
     * The priceCatShortName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceCatShortName;
    /**
     * The priceCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $priceCategory;
    /**
     * The priceCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceCurrency;
    /**
     * The referenceAuctionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $referenceAuctionNumber;
    /**
     * The senderType
     * @var int
     */
    public $senderType;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\S2SService
     */
    public $service;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The shipmentPrice
     * @var int
     */
    public $shipmentPrice;
    /**
     * The surchargeLongName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surchargeLongName;
    /**
     * The surchargePrice
     * @var int
     */
    public $surchargePrice;
    /**
     * Constructor method for c2CShipment
     * @uses C2CShipment::setPayment()
     * @uses C2CShipment::setPriceCatLongName()
     * @uses C2CShipment::setPriceCatShortName()
     * @uses C2CShipment::setPriceCategory()
     * @uses C2CShipment::setPriceCurrency()
     * @uses C2CShipment::setReferenceAuctionNumber()
     * @uses C2CShipment::setSenderType()
     * @uses C2CShipment::setService()
     * @uses C2CShipment::setServices()
     * @uses C2CShipment::setShipmentPrice()
     * @uses C2CShipment::setSurchargeLongName()
     * @uses C2CShipment::setSurchargePrice()
     * @param \StructType\Payment $payment
     * @param string $priceCatLongName
     * @param string $priceCatShortName
     * @param int $priceCategory
     * @param string $priceCurrency
     * @param string $referenceAuctionNumber
     * @param int $senderType
     * @param \StructType\S2SService $service
     * @param \StructType\Services $services
     * @param int $shipmentPrice
     * @param string $surchargeLongName
     * @param int $surchargePrice
     */
    public function __construct(\StructType\Payment $payment = null, $priceCatLongName = null, $priceCatShortName = null, $priceCategory = null, $priceCurrency = null, $referenceAuctionNumber = null, $senderType = null, \StructType\S2SService $service = null, \StructType\Services $services = null, $shipmentPrice = null, $surchargeLongName = null, $surchargePrice = null)
    {
        $this
            ->setPayment($payment)
            ->setPriceCatLongName($priceCatLongName)
            ->setPriceCatShortName($priceCatShortName)
            ->setPriceCategory($priceCategory)
            ->setPriceCurrency($priceCurrency)
            ->setReferenceAuctionNumber($referenceAuctionNumber)
            ->setSenderType($senderType)
            ->setService($service)
            ->setServices($services)
            ->setShipmentPrice($shipmentPrice)
            ->setSurchargeLongName($surchargeLongName)
            ->setSurchargePrice($surchargePrice);
    }
    /**
     * Get payment value
     * @return \StructType\Payment|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param \StructType\Payment $payment
     * @return \StructType\C2CShipment
     */
    public function setPayment(\StructType\Payment $payment = null)
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get priceCatLongName value
     * @return string|null
     */
    public function getPriceCatLongName()
    {
        return $this->priceCatLongName;
    }
    /**
     * Set priceCatLongName value
     * @param string $priceCatLongName
     * @return \StructType\C2CShipment
     */
    public function setPriceCatLongName($priceCatLongName = null)
    {
        // validation for constraint: string
        if (!is_null($priceCatLongName) && !is_string($priceCatLongName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceCatLongName)), __LINE__);
        }
        $this->priceCatLongName = $priceCatLongName;
        return $this;
    }
    /**
     * Get priceCatShortName value
     * @return string|null
     */
    public function getPriceCatShortName()
    {
        return $this->priceCatShortName;
    }
    /**
     * Set priceCatShortName value
     * @param string $priceCatShortName
     * @return \StructType\C2CShipment
     */
    public function setPriceCatShortName($priceCatShortName = null)
    {
        // validation for constraint: string
        if (!is_null($priceCatShortName) && !is_string($priceCatShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceCatShortName)), __LINE__);
        }
        $this->priceCatShortName = $priceCatShortName;
        return $this;
    }
    /**
     * Get priceCategory value
     * @return int|null
     */
    public function getPriceCategory()
    {
        return $this->priceCategory;
    }
    /**
     * Set priceCategory value
     * @param int $priceCategory
     * @return \StructType\C2CShipment
     */
    public function setPriceCategory($priceCategory = null)
    {
        // validation for constraint: int
        if (!is_null($priceCategory) && !is_numeric($priceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceCategory)), __LINE__);
        }
        $this->priceCategory = $priceCategory;
        return $this;
    }
    /**
     * Get priceCurrency value
     * @return string|null
     */
    public function getPriceCurrency()
    {
        return $this->priceCurrency;
    }
    /**
     * Set priceCurrency value
     * @param string $priceCurrency
     * @return \StructType\C2CShipment
     */
    public function setPriceCurrency($priceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($priceCurrency) && !is_string($priceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceCurrency)), __LINE__);
        }
        $this->priceCurrency = $priceCurrency;
        return $this;
    }
    /**
     * Get referenceAuctionNumber value
     * @return string|null
     */
    public function getReferenceAuctionNumber()
    {
        return $this->referenceAuctionNumber;
    }
    /**
     * Set referenceAuctionNumber value
     * @param string $referenceAuctionNumber
     * @return \StructType\C2CShipment
     */
    public function setReferenceAuctionNumber($referenceAuctionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceAuctionNumber) && !is_string($referenceAuctionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceAuctionNumber)), __LINE__);
        }
        $this->referenceAuctionNumber = $referenceAuctionNumber;
        return $this;
    }
    /**
     * Get senderType value
     * @return int|null
     */
    public function getSenderType()
    {
        return $this->senderType;
    }
    /**
     * Set senderType value
     * @param int $senderType
     * @return \StructType\C2CShipment
     */
    public function setSenderType($senderType = null)
    {
        // validation for constraint: int
        if (!is_null($senderType) && !is_numeric($senderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($senderType)), __LINE__);
        }
        $this->senderType = $senderType;
        return $this;
    }
    /**
     * Get service value
     * @return \StructType\S2SService|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param \StructType\S2SService $service
     * @return \StructType\C2CShipment
     */
    public function setService(\StructType\S2SService $service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\C2CShipment
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get shipmentPrice value
     * @return int|null
     */
    public function getShipmentPrice()
    {
        return $this->shipmentPrice;
    }
    /**
     * Set shipmentPrice value
     * @param int $shipmentPrice
     * @return \StructType\C2CShipment
     */
    public function setShipmentPrice($shipmentPrice = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentPrice) && !is_numeric($shipmentPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipmentPrice)), __LINE__);
        }
        $this->shipmentPrice = $shipmentPrice;
        return $this;
    }
    /**
     * Get surchargeLongName value
     * @return string|null
     */
    public function getSurchargeLongName()
    {
        return $this->surchargeLongName;
    }
    /**
     * Set surchargeLongName value
     * @param string $surchargeLongName
     * @return \StructType\C2CShipment
     */
    public function setSurchargeLongName($surchargeLongName = null)
    {
        // validation for constraint: string
        if (!is_null($surchargeLongName) && !is_string($surchargeLongName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surchargeLongName)), __LINE__);
        }
        $this->surchargeLongName = $surchargeLongName;
        return $this;
    }
    /**
     * Get surchargePrice value
     * @return int|null
     */
    public function getSurchargePrice()
    {
        return $this->surchargePrice;
    }
    /**
     * Set surchargePrice value
     * @param int $surchargePrice
     * @return \StructType\C2CShipment
     */
    public function setSurchargePrice($surchargePrice = null)
    {
        // validation for constraint: int
        if (!is_null($surchargePrice) && !is_numeric($surchargePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surchargePrice)), __LINE__);
        }
        $this->surchargePrice = $surchargePrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\C2CShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
