<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for c2COrder StructType
 * @subpackage Structs
 */
class C2COrder extends AbstractStructBase
{
    /**
     * The acceptanceLiability
     * @var bool
     */
    public $acceptanceLiability;
    /**
     * The acceptanceTaC
     * @var bool
     */
    public $acceptanceTaC;
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNo;
    /**
     * The orderOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderOrigin;
    /**
     * The pointOfReceipt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pointOfReceipt;
    /**
     * The senderAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $senderAddress;
    /**
     * The shipmentList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\C2CShipment[]
     */
    public $shipmentList;
    /**
     * Constructor method for c2COrder
     * @uses C2COrder::setAcceptanceLiability()
     * @uses C2COrder::setAcceptanceTaC()
     * @uses C2COrder::setOrderNo()
     * @uses C2COrder::setOrderOrigin()
     * @uses C2COrder::setPointOfReceipt()
     * @uses C2COrder::setSenderAddress()
     * @uses C2COrder::setShipmentList()
     * @param bool $acceptanceLiability
     * @param bool $acceptanceTaC
     * @param string $orderNo
     * @param string $orderOrigin
     * @param int $pointOfReceipt
     * @param \StructType\Address $senderAddress
     * @param \StructType\C2CShipment[] $shipmentList
     */
    public function __construct($acceptanceLiability = null, $acceptanceTaC = null, $orderNo = null, $orderOrigin = null, $pointOfReceipt = null, \StructType\Address $senderAddress = null, array $shipmentList = array())
    {
        $this
            ->setAcceptanceLiability($acceptanceLiability)
            ->setAcceptanceTaC($acceptanceTaC)
            ->setOrderNo($orderNo)
            ->setOrderOrigin($orderOrigin)
            ->setPointOfReceipt($pointOfReceipt)
            ->setSenderAddress($senderAddress)
            ->setShipmentList($shipmentList);
    }
    /**
     * Get acceptanceLiability value
     * @return bool|null
     */
    public function getAcceptanceLiability()
    {
        return $this->acceptanceLiability;
    }
    /**
     * Set acceptanceLiability value
     * @param bool $acceptanceLiability
     * @return \StructType\C2COrder
     */
    public function setAcceptanceLiability($acceptanceLiability = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptanceLiability) && !is_bool($acceptanceLiability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptanceLiability)), __LINE__);
        }
        $this->acceptanceLiability = $acceptanceLiability;
        return $this;
    }
    /**
     * Get acceptanceTaC value
     * @return bool|null
     */
    public function getAcceptanceTaC()
    {
        return $this->acceptanceTaC;
    }
    /**
     * Set acceptanceTaC value
     * @param bool $acceptanceTaC
     * @return \StructType\C2COrder
     */
    public function setAcceptanceTaC($acceptanceTaC = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptanceTaC) && !is_bool($acceptanceTaC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptanceTaC)), __LINE__);
        }
        $this->acceptanceTaC = $acceptanceTaC;
        return $this;
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\C2COrder
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get orderOrigin value
     * @return string|null
     */
    public function getOrderOrigin()
    {
        return $this->orderOrigin;
    }
    /**
     * Set orderOrigin value
     * @param string $orderOrigin
     * @return \StructType\C2COrder
     */
    public function setOrderOrigin($orderOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($orderOrigin) && !is_string($orderOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderOrigin)), __LINE__);
        }
        $this->orderOrigin = $orderOrigin;
        return $this;
    }
    /**
     * Get pointOfReceipt value
     * @return int|null
     */
    public function getPointOfReceipt()
    {
        return $this->pointOfReceipt;
    }
    /**
     * Set pointOfReceipt value
     * @param int $pointOfReceipt
     * @return \StructType\C2COrder
     */
    public function setPointOfReceipt($pointOfReceipt = null)
    {
        // validation for constraint: int
        if (!is_null($pointOfReceipt) && !is_numeric($pointOfReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pointOfReceipt)), __LINE__);
        }
        $this->pointOfReceipt = $pointOfReceipt;
        return $this;
    }
    /**
     * Get senderAddress value
     * @return \StructType\Address|null
     */
    public function getSenderAddress()
    {
        return $this->senderAddress;
    }
    /**
     * Set senderAddress value
     * @param \StructType\Address $senderAddress
     * @return \StructType\C2COrder
     */
    public function setSenderAddress(\StructType\Address $senderAddress = null)
    {
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get shipmentList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\C2CShipment[]|null
     */
    public function getShipmentList()
    {
        return isset($this->shipmentList) ? $this->shipmentList : null;
    }
    /**
     * Set shipmentList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\C2CShipment[] $shipmentList
     * @return \StructType\C2COrder
     */
    public function setShipmentList(array $shipmentList = array())
    {
        foreach ($shipmentList as $c2COrderShipmentListItem) {
            // validation for constraint: itemType
            if (!$c2COrderShipmentListItem instanceof \StructType\C2CShipment) {
                throw new \InvalidArgumentException(sprintf('The shipmentList property can only contain items of \StructType\C2CShipment, "%s" given', is_object($c2COrderShipmentListItem) ? get_class($c2COrderShipmentListItem) : gettype($c2COrderShipmentListItem)), __LINE__);
            }
        }
        if (is_null($shipmentList) || (is_array($shipmentList) && empty($shipmentList))) {
            unset($this->shipmentList);
        } else {
            $this->shipmentList = $shipmentList;
        }
        return $this;
    }
    /**
     * Add item to shipmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\C2CShipment $item
     * @return \StructType\C2COrder
     */
    public function addToShipmentList(\StructType\C2CShipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\C2CShipment) {
            throw new \InvalidArgumentException(sprintf('The shipmentList property can only contain items of \StructType\C2CShipment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shipmentList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\C2COrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
