<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for c2BReturns StructType
 * @subpackage Structs
 */
class C2BReturns extends Returns
{
    /**
     * The deliveryMessage2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryMessage2;
    /**
     * The numberParcels
     * @var int
     */
    public $numberParcels;
    /**
     * The returnsService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnsService
     */
    public $returnsService;
    /**
     * The senderAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $senderAddress;
    /**
     * The warehouseNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $warehouseNo;
    /**
     * Constructor method for c2BReturns
     * @uses C2BReturns::setDeliveryMessage2()
     * @uses C2BReturns::setNumberParcels()
     * @uses C2BReturns::setReturnsService()
     * @uses C2BReturns::setSenderAddress()
     * @uses C2BReturns::setWarehouseNo()
     * @param string $deliveryMessage2
     * @param int $numberParcels
     * @param \StructType\ReturnsService $returnsService
     * @param \StructType\Address $senderAddress
     * @param string $warehouseNo
     */
    public function __construct($deliveryMessage2 = null, $numberParcels = null, \StructType\ReturnsService $returnsService = null, \StructType\Address $senderAddress = null, $warehouseNo = null)
    {
        $this
            ->setDeliveryMessage2($deliveryMessage2)
            ->setNumberParcels($numberParcels)
            ->setReturnsService($returnsService)
            ->setSenderAddress($senderAddress)
            ->setWarehouseNo($warehouseNo);
    }
    /**
     * Get deliveryMessage2 value
     * @return string|null
     */
    public function getDeliveryMessage2()
    {
        return $this->deliveryMessage2;
    }
    /**
     * Set deliveryMessage2 value
     * @param string $deliveryMessage2
     * @return \StructType\C2BReturns
     */
    public function setDeliveryMessage2($deliveryMessage2 = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMessage2) && !is_string($deliveryMessage2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryMessage2)), __LINE__);
        }
        $this->deliveryMessage2 = $deliveryMessage2;
        return $this;
    }
    /**
     * Get numberParcels value
     * @return int|null
     */
    public function getNumberParcels()
    {
        return $this->numberParcels;
    }
    /**
     * Set numberParcels value
     * @param int $numberParcels
     * @return \StructType\C2BReturns
     */
    public function setNumberParcels($numberParcels = null)
    {
        // validation for constraint: int
        if (!is_null($numberParcels) && !is_numeric($numberParcels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberParcels)), __LINE__);
        }
        $this->numberParcels = $numberParcels;
        return $this;
    }
    /**
     * Get returnsService value
     * @return \StructType\ReturnsService|null
     */
    public function getReturnsService()
    {
        return $this->returnsService;
    }
    /**
     * Set returnsService value
     * @param \StructType\ReturnsService $returnsService
     * @return \StructType\C2BReturns
     */
    public function setReturnsService(\StructType\ReturnsService $returnsService = null)
    {
        $this->returnsService = $returnsService;
        return $this;
    }
    /**
     * Get senderAddress value
     * @return \StructType\Address|null
     */
    public function getSenderAddress()
    {
        return $this->senderAddress;
    }
    /**
     * Set senderAddress value
     * @param \StructType\Address $senderAddress
     * @return \StructType\C2BReturns
     */
    public function setSenderAddress(\StructType\Address $senderAddress = null)
    {
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get warehouseNo value
     * @return string|null
     */
    public function getWarehouseNo()
    {
        return $this->warehouseNo;
    }
    /**
     * Set warehouseNo value
     * @param string $warehouseNo
     * @return \StructType\C2BReturns
     */
    public function setWarehouseNo($warehouseNo = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseNo) && !is_string($warehouseNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseNo)), __LINE__);
        }
        $this->warehouseNo = $warehouseNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\C2BReturns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
