<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResponse StructType
 * @subpackage Structs
 */
abstract class BaseResponse extends AbstractStructBase
{
    /**
     * The labels
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Label[]
     */
    public $labels;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErosUserError[]
     */
    public $errors;
    /**
     * The labelOutputFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelOutputFormat;
    /**
     * Constructor method for BaseResponse
     * @uses BaseResponse::setLabels()
     * @uses BaseResponse::setErrors()
     * @uses BaseResponse::setLabelOutputFormat()
     * @param \StructType\Label[] $labels
     * @param \StructType\ErosUserError[] $errors
     * @param string $labelOutputFormat
     */
    public function __construct(array $labels = array(), array $errors = array(), $labelOutputFormat = null)
    {
        $this
            ->setLabels($labels)
            ->setErrors($errors)
            ->setLabelOutputFormat($labelOutputFormat);
    }
    /**
     * Get labels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Label[]|null
     */
    public function getLabels()
    {
        return isset($this->labels) ? $this->labels : null;
    }
    /**
     * Set labels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Label[] $labels
     * @return \StructType\BaseResponse
     */
    public function setLabels(array $labels = array())
    {
        foreach ($labels as $baseResponseLabelsItem) {
            // validation for constraint: itemType
            if (!$baseResponseLabelsItem instanceof \StructType\Label) {
                throw new \InvalidArgumentException(sprintf('The labels property can only contain items of \StructType\Label, "%s" given', is_object($baseResponseLabelsItem) ? get_class($baseResponseLabelsItem) : gettype($baseResponseLabelsItem)), __LINE__);
            }
        }
        if (is_null($labels) || (is_array($labels) && empty($labels))) {
            unset($this->labels);
        } else {
            $this->labels = $labels;
        }
        return $this;
    }
    /**
     * Add item to labels value
     * @throws \InvalidArgumentException
     * @param \StructType\Label $item
     * @return \StructType\BaseResponse
     */
    public function addToLabels(\StructType\Label $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Label) {
            throw new \InvalidArgumentException(sprintf('The labels property can only contain items of \StructType\Label, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->labels[] = $item;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErosUserError[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserError[] $errors
     * @return \StructType\BaseResponse
     */
    public function setErrors(array $errors = array())
    {
        foreach ($errors as $baseResponseErrorsItem) {
            // validation for constraint: itemType
            if (!$baseResponseErrorsItem instanceof \StructType\ErosUserError) {
                throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \StructType\ErosUserError, "%s" given', is_object($baseResponseErrorsItem) ? get_class($baseResponseErrorsItem) : gettype($baseResponseErrorsItem)), __LINE__);
            }
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \StructType\ErosUserError $item
     * @return \StructType\BaseResponse
     */
    public function addToErrors(\StructType\ErosUserError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErosUserError) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \StructType\ErosUserError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get labelOutputFormat value
     * @return string|null
     */
    public function getLabelOutputFormat()
    {
        return $this->labelOutputFormat;
    }
    /**
     * Set labelOutputFormat value
     * @param string $labelOutputFormat
     * @return \StructType\BaseResponse
     */
    public function setLabelOutputFormat($labelOutputFormat = null)
    {
        // validation for constraint: string
        if (!is_null($labelOutputFormat) && !is_string($labelOutputFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelOutputFormat)), __LINE__);
        }
        $this->labelOutputFormat = $labelOutputFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
