<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * @subpackage Structs
 */
abstract class BaseRequest extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNo;
    /**
     * The length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $length;
    /**
     * The width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $width;
    /**
     * The depth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $depth;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $volume;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * The requiredDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requiredDate;
    /**
     * The productCode
     * @var int
     */
    public $productCode;
    /**
     * The customerReference1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerReference1;
    /**
     * The customerReference2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerReference2;
    /**
     * The deliveryMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryMessage;
    /**
     * The countryOfOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The requestScope
     * @var int
     */
    public $requestScope;
    /**
     * The recipientAddress
     * @var \StructType\Address
     */
    public $recipientAddress;
    /**
     * The carrierCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $carrierCode;
    /**
     * The originatingCarrierBarcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $originatingCarrierBarcode;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setOrderNo()
     * @uses BaseRequest::setLength()
     * @uses BaseRequest::setWidth()
     * @uses BaseRequest::setDepth()
     * @uses BaseRequest::setVolume()
     * @uses BaseRequest::setWeight()
     * @uses BaseRequest::setRequiredDate()
     * @uses BaseRequest::setProductCode()
     * @uses BaseRequest::setCustomerReference1()
     * @uses BaseRequest::setCustomerReference2()
     * @uses BaseRequest::setDeliveryMessage()
     * @uses BaseRequest::setCountryOfOrigin()
     * @uses BaseRequest::setRequestScope()
     * @uses BaseRequest::setRecipientAddress()
     * @uses BaseRequest::setCarrierCode()
     * @uses BaseRequest::setOriginatingCarrierBarcode()
     * @param string $orderNo
     * @param int $length
     * @param int $width
     * @param int $depth
     * @param int $volume
     * @param int $weight
     * @param string $requiredDate
     * @param int $productCode
     * @param string $customerReference1
     * @param string $customerReference2
     * @param string $deliveryMessage
     * @param string $countryOfOrigin
     * @param int $requestScope
     * @param \StructType\Address $recipientAddress
     * @param string $carrierCode
     * @param string $originatingCarrierBarcode
     */
    public function __construct($orderNo = null, $length = null, $width = null, $depth = null, $volume = null, $weight = null, $requiredDate = null, $productCode = null, $customerReference1 = null, $customerReference2 = null, $deliveryMessage = null, $countryOfOrigin = null, $requestScope = null, \StructType\Address $recipientAddress = null, $carrierCode = null, $originatingCarrierBarcode = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setLength($length)
            ->setWidth($width)
            ->setDepth($depth)
            ->setVolume($volume)
            ->setWeight($weight)
            ->setRequiredDate($requiredDate)
            ->setProductCode($productCode)
            ->setCustomerReference1($customerReference1)
            ->setCustomerReference2($customerReference2)
            ->setDeliveryMessage($deliveryMessage)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setRequestScope($requestScope)
            ->setRecipientAddress($recipientAddress)
            ->setCarrierCode($carrierCode)
            ->setOriginatingCarrierBarcode($originatingCarrierBarcode);
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\BaseRequest
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \StructType\BaseRequest
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param int $width
     * @return \StructType\BaseRequest
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !is_numeric($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get depth value
     * @return int|null
     */
    public function getDepth()
    {
        return $this->depth;
    }
    /**
     * Set depth value
     * @param int $depth
     * @return \StructType\BaseRequest
     */
    public function setDepth($depth = null)
    {
        // validation for constraint: int
        if (!is_null($depth) && !is_numeric($depth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depth)), __LINE__);
        }
        $this->depth = $depth;
        return $this;
    }
    /**
     * Get volume value
     * @return int|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param int $volume
     * @return \StructType\BaseRequest
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: int
        if (!is_null($volume) && !is_numeric($volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($volume)), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \StructType\BaseRequest
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get requiredDate value
     * @return string|null
     */
    public function getRequiredDate()
    {
        return $this->requiredDate;
    }
    /**
     * Set requiredDate value
     * @param string $requiredDate
     * @return \StructType\BaseRequest
     */
    public function setRequiredDate($requiredDate = null)
    {
        // validation for constraint: string
        if (!is_null($requiredDate) && !is_string($requiredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredDate)), __LINE__);
        }
        $this->requiredDate = $requiredDate;
        return $this;
    }
    /**
     * Get productCode value
     * @return int|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param int $productCode
     * @return \StructType\BaseRequest
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: int
        if (!is_null($productCode) && !is_numeric($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get customerReference1 value
     * @return string|null
     */
    public function getCustomerReference1()
    {
        return $this->customerReference1;
    }
    /**
     * Set customerReference1 value
     * @param string $customerReference1
     * @return \StructType\BaseRequest
     */
    public function setCustomerReference1($customerReference1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference1) && !is_string($customerReference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference1)), __LINE__);
        }
        $this->customerReference1 = $customerReference1;
        return $this;
    }
    /**
     * Get customerReference2 value
     * @return string|null
     */
    public function getCustomerReference2()
    {
        return $this->customerReference2;
    }
    /**
     * Set customerReference2 value
     * @param string $customerReference2
     * @return \StructType\BaseRequest
     */
    public function setCustomerReference2($customerReference2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference2) && !is_string($customerReference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference2)), __LINE__);
        }
        $this->customerReference2 = $customerReference2;
        return $this;
    }
    /**
     * Get deliveryMessage value
     * @return string|null
     */
    public function getDeliveryMessage()
    {
        return $this->deliveryMessage;
    }
    /**
     * Set deliveryMessage value
     * @param string $deliveryMessage
     * @return \StructType\BaseRequest
     */
    public function setDeliveryMessage($deliveryMessage = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMessage) && !is_string($deliveryMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryMessage)), __LINE__);
        }
        $this->deliveryMessage = $deliveryMessage;
        return $this;
    }
    /**
     * Get countryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \StructType\BaseRequest
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get requestScope value
     * @return int|null
     */
    public function getRequestScope()
    {
        return $this->requestScope;
    }
    /**
     * Set requestScope value
     * @param int $requestScope
     * @return \StructType\BaseRequest
     */
    public function setRequestScope($requestScope = null)
    {
        // validation for constraint: int
        if (!is_null($requestScope) && !is_numeric($requestScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestScope)), __LINE__);
        }
        $this->requestScope = $requestScope;
        return $this;
    }
    /**
     * Get recipientAddress value
     * @return \StructType\Address|null
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }
    /**
     * Set recipientAddress value
     * @param \StructType\Address $recipientAddress
     * @return \StructType\BaseRequest
     */
    public function setRecipientAddress(\StructType\Address $recipientAddress = null)
    {
        $this->recipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get carrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->carrierCode;
    }
    /**
     * Set carrierCode value
     * @param string $carrierCode
     * @return \StructType\BaseRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->carrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get originatingCarrierBarcode value
     * @return string|null
     */
    public function getOriginatingCarrierBarcode()
    {
        return $this->originatingCarrierBarcode;
    }
    /**
     * Set originatingCarrierBarcode value
     * @param string $originatingCarrierBarcode
     * @return \StructType\BaseRequest
     */
    public function setOriginatingCarrierBarcode($originatingCarrierBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($originatingCarrierBarcode) && !is_string($originatingCarrierBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originatingCarrierBarcode)), __LINE__);
        }
        $this->originatingCarrierBarcode = $originatingCarrierBarcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
