<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Barcode StructType
 * @subpackage Structs
 */
class Barcode extends AbstractStructBase
{
    /**
     * The barcodeNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $barcodeNumber;
    /**
     * The barcodeLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $barcodeLength;
    /**
     * The barcodeSymbology
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $barcodeSymbology;
    /**
     * The barcodeDisplay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $barcodeDisplay;
    /**
     * Constructor method for Barcode
     * @uses Barcode::setBarcodeNumber()
     * @uses Barcode::setBarcodeLength()
     * @uses Barcode::setBarcodeSymbology()
     * @uses Barcode::setBarcodeDisplay()
     * @param string $barcodeNumber
     * @param string $barcodeLength
     * @param string $barcodeSymbology
     * @param string $barcodeDisplay
     */
    public function __construct($barcodeNumber = null, $barcodeLength = null, $barcodeSymbology = null, $barcodeDisplay = null)
    {
        $this
            ->setBarcodeNumber($barcodeNumber)
            ->setBarcodeLength($barcodeLength)
            ->setBarcodeSymbology($barcodeSymbology)
            ->setBarcodeDisplay($barcodeDisplay);
    }
    /**
     * Get barcodeNumber value
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->barcodeNumber;
    }
    /**
     * Set barcodeNumber value
     * @param string $barcodeNumber
     * @return \StructType\Barcode
     */
    public function setBarcodeNumber($barcodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNumber) && !is_string($barcodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeNumber)), __LINE__);
        }
        $this->barcodeNumber = $barcodeNumber;
        return $this;
    }
    /**
     * Get barcodeLength value
     * @return string|null
     */
    public function getBarcodeLength()
    {
        return $this->barcodeLength;
    }
    /**
     * Set barcodeLength value
     * @param string $barcodeLength
     * @return \StructType\Barcode
     */
    public function setBarcodeLength($barcodeLength = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeLength) && !is_string($barcodeLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeLength)), __LINE__);
        }
        $this->barcodeLength = $barcodeLength;
        return $this;
    }
    /**
     * Get barcodeSymbology value
     * @return string|null
     */
    public function getBarcodeSymbology()
    {
        return $this->barcodeSymbology;
    }
    /**
     * Set barcodeSymbology value
     * @param string $barcodeSymbology
     * @return \StructType\Barcode
     */
    public function setBarcodeSymbology($barcodeSymbology = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeSymbology) && !is_string($barcodeSymbology)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeSymbology)), __LINE__);
        }
        $this->barcodeSymbology = $barcodeSymbology;
        return $this;
    }
    /**
     * Get barcodeDisplay value
     * @return string|null
     */
    public function getBarcodeDisplay()
    {
        return $this->barcodeDisplay;
    }
    /**
     * Set barcodeDisplay value
     * @param string $barcodeDisplay
     * @return \StructType\Barcode
     */
    public function setBarcodeDisplay($barcodeDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeDisplay) && !is_string($barcodeDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeDisplay)), __LINE__);
        }
        $this->barcodeDisplay = $barcodeDisplay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Barcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
